@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorAgentPropertiesBaseResponse.Companion.toKotlin as collectorAgentPropertiesBaseResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HypervCollectorsOperation].
 */
@PulumiTagMarker
public class HypervCollectorsOperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HypervCollectorsOperationArgs = HypervCollectorsOperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HypervCollectorsOperationArgsBuilder.() -> Unit) {
        val builder = HypervCollectorsOperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HypervCollectorsOperation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.HypervCollectorsOperation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HypervCollectorsOperation(builtJavaResource)
    }
}

/**
 * Hyper-V collector resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### HypervCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervCollectorsOperation = new AzureNative.Migrate.HypervCollectorsOperation("hypervCollectorsOperation", new()
 *     {
 *         AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesBaseArgs
 *         {
 *             Id = "12f1d90f-b3fa-4926-8893-e56803a09af0",
 *             LastHeartbeatUtc = "2022-07-07T14:25:35.708325Z",
 *             SpnDetails = new AzureNative.Migrate.Inputs.CollectorAgentSpnPropertiesBaseArgs
 *             {
 *                 ApplicationId = "e3bd6eaa-980b-40ae-a30e-2a5069ba097c",
 *                 Audience = "e3bd6eaa-980b-40ae-a30e-2a5069ba097c",
 *                 Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 ObjectId = "01b9f9e2-2d82-414c-adaa-09ce259b6b44",
 *                 TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *             },
 *             Version = "2.0.1993.19",
 *         },
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site",
 *         HypervCollectorName = "test-697cecollector",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewHypervCollectorsOperation(ctx, "hypervCollectorsOperation", &migrate.HypervCollectorsOperationArgs{
 * 			AgentProperties: migrate.CollectorAgentPropertiesBaseResponse{
 * 				Id:               pulumi.String("12f1d90f-b3fa-4926-8893-e56803a09af0"),
 * 				LastHeartbeatUtc: pulumi.String("2022-07-07T14:25:35.708325Z"),
 * 				SpnDetails: &migrate.CollectorAgentSpnPropertiesBaseArgs{
 * 					ApplicationId: pulumi.String("e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 * 					Audience:      pulumi.String("e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 * 					Authority:     pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 					ObjectId:      pulumi.String("01b9f9e2-2d82-414c-adaa-09ce259b6b44"),
 * 					TenantId:      pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * 				},
 * 				Version: pulumi.String("2.0.1993.19"),
 * 			},
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site"),
 * 			HypervCollectorName: pulumi.String("test-697cecollector"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String("Succeeded"),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.HypervCollectorsOperation;
 * import com.pulumi.azurenative.migrate.HypervCollectorsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervCollectorsOperation = new HypervCollectorsOperation("hypervCollectorsOperation", HypervCollectorsOperationArgs.builder()
 *             .agentProperties(Map.ofEntries(
 *                 Map.entry("id", "12f1d90f-b3fa-4926-8893-e56803a09af0"),
 *                 Map.entry("lastHeartbeatUtc", "2022-07-07T14:25:35.708325Z"),
 *                 Map.entry("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 *                     Map.entry("audience", "e3bd6eaa-980b-40ae-a30e-2a5069ba097c"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "01b9f9e2-2d82-414c-adaa-09ce259b6b44"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 )),
 *                 Map.entry("version", "2.0.1993.19")
 *             ))
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/ayagrawRG/providers/Microsoft.OffAzure/HyperVSites/test-60527site")
 *             .hypervCollectorName("test-697cecollector")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:HypervCollectorsOperation test-697cecollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/hypervcollectors/{hypervCollectorName}
 * ```
 */
public class HypervCollectorsOperation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.HypervCollectorsOperation,
) : KotlinCustomResource(javaResource, HypervCollectorsOperationMapper) {
    /**
     * Gets or sets the collector agent properties.
     */
    public val agentProperties: Output<CollectorAgentPropertiesBaseResponse>?
        get() = javaResource.agentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> collectorAgentPropertiesBaseResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets the Timestamp when collector was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the discovery site id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Timestamp when collector was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object HypervCollectorsOperationMapper : ResourceMapper<HypervCollectorsOperation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.HypervCollectorsOperation::class == javaResource::class

    override fun map(javaResource: Resource): HypervCollectorsOperation =
        HypervCollectorsOperation(
            javaResource as
                com.pulumi.azurenative.migrate.HypervCollectorsOperation,
        )
}

/**
 * @see [HypervCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HypervCollectorsOperation].
 */
public suspend fun hypervCollectorsOperation(
    name: String,
    block: suspend HypervCollectorsOperationResourceBuilder.() -> Unit,
): HypervCollectorsOperation {
    val builder = HypervCollectorsOperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HypervCollectorsOperation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hypervCollectorsOperation(name: String): HypervCollectorsOperation {
    val builder = HypervCollectorsOperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
