@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ProvisioningState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Import collector resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### ImportCollectorsOperations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importCollectorsOperation = new AzureNative.Migrate.ImportCollectorsOperation("importCollectorsOperation", new()
 *     {
 *         DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite",
 *         ImportCollectorName = "importCollectore7d5",
 *         ProjectName = "app18700project",
 *         ProvisioningState = "Succeeded",
 *         ResourceGroupName = "ayagrawRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewImportCollectorsOperation(ctx, "importCollectorsOperation", &migrate.ImportCollectorsOperationArgs{
 * 			DiscoverySiteId:     pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite"),
 * 			ImportCollectorName: pulumi.String("importCollectore7d5"),
 * 			ProjectName:         pulumi.String("app18700project"),
 * 			ProvisioningState:   pulumi.String("Succeeded"),
 * 			ResourceGroupName:   pulumi.String("ayagrawRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ImportCollectorsOperation;
 * import com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importCollectorsOperation = new ImportCollectorsOperation("importCollectorsOperation", ImportCollectorsOperationArgs.builder()
 *             .discoverySiteId("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourcegroups/ayagrawRG/providers/microsoft.offazure/importsites/actualSEA37d4importSite")
 *             .importCollectorName("importCollectore7d5")
 *             .projectName("app18700project")
 *             .provisioningState("Succeeded")
 *             .resourceGroupName("ayagrawRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ImportCollectorsOperation importCollectore7d5 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/importcollectors/{importCollectorName}
 * ```
 * @property discoverySiteId Gets the discovery site id.
 * @property importCollectorName Import collector ARM name
 * @property projectName Assessment Project Name
 * @property provisioningState The status of the last operation.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ImportCollectorsOperationArgs(
    public val discoverySiteId: Output<String>? = null,
    public val importCollectorName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val provisioningState: Output<Either<String, ProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs =
        com.pulumi.azurenative.migrate.ImportCollectorsOperationArgs.builder()
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 }))
            .importCollectorName(importCollectorName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImportCollectorsOperationArgs].
 */
@PulumiTagMarker
public class ImportCollectorsOperationArgsBuilder internal constructor() {
    private var discoverySiteId: Output<String>? = null

    private var importCollectorName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var provisioningState: Output<Either<String, ProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("dgmwepvmhodusaoj")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value Import collector ARM name
     */
    @JvmName("fnkxaqyafbxqnvpl")
    public suspend fun importCollectorName(`value`: Output<String>) {
        this.importCollectorName = value
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ccngtyyaqfdnrelu")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("jehohcythvursttc")
    public suspend fun provisioningState(`value`: Output<Either<String, ProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aafhunsnjmmkjrrf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets the discovery site id.
     */
    @JvmName("jijtiyipcnvrxyds")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    /**
     * @param value Import collector ARM name
     */
    @JvmName("skvmrshnusmehoux")
    public suspend fun importCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importCollectorName = mapped
    }

    /**
     * @param value Assessment Project Name
     */
    @JvmName("cuhewlweweaixtqq")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("rdydxbdbmhpadtrn")
    public suspend fun provisioningState(`value`: Either<String, ProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("gajsrxtneqxnftoe")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The status of the last operation.
     */
    @JvmName("gbkdcowofcfpfxwp")
    public fun provisioningState(`value`: ProvisioningState) {
        val toBeMapped = Either.ofRight<String, ProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("epqemdmovxkxqvjo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ImportCollectorsOperationArgs = ImportCollectorsOperationArgs(
        discoverySiteId = discoverySiteId,
        importCollectorName = importCollectorName,
        projectName = projectName,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
