@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.MigrateProjectArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectPropertiesArgsBuilder
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectTagsArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.MigrateProjectTagsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Migrate Project REST Resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### MigrateProjects_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateProject = new AzureNative.Migrate.MigrateProject("migrateProject", new()
 *     {
 *         ETag = "\"b701c73a-0000-0000-0000-59c12ff00000\"",
 *         Location = "Southeast Asia",
 *         MigrateProjectName = "project01",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateProject(ctx, "migrateProject", &migrate.MigrateProjectArgs{
 * 			ETag:               pulumi.String("\"b701c73a-0000-0000-0000-59c12ff00000\""),
 * 			Location:           pulumi.String("Southeast Asia"),
 * 			MigrateProjectName: pulumi.String("project01"),
 * 			Properties:         nil,
 * 			ResourceGroupName:  pulumi.String("myResourceGroup"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateProject;
 * import com.pulumi.azurenative.migrate.MigrateProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateProject = new MigrateProject("migrateProject", MigrateProjectArgs.builder()
 *             .eTag("\"b701c73a-0000-0000-0000-59c12ff00000\"")
 *             .location("Southeast Asia")
 *             .migrateProjectName("project01")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateProject project01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}
 * ```
 * @property eTag Gets or sets the eTag for concurrency control.
 * @property location Gets or sets the Azure location in which migrate project is created.
 * @property migrateProjectName Name of the Azure Migrate project.
 * @property properties Gets or sets the nested properties.
 * @property resourceGroupName Name of the Azure Resource Group that migrate project is part of.
 * @property tags Gets or sets the tags.
 */
public data class MigrateProjectArgs(
    public val eTag: Output<String>? = null,
    public val location: Output<String>? = null,
    public val migrateProjectName: Output<String>? = null,
    public val properties: Output<MigrateProjectPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<MigrateProjectTagsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.MigrateProjectArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.MigrateProjectArgs =
        com.pulumi.azurenative.migrate.MigrateProjectArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .migrateProjectName(migrateProjectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MigrateProjectArgs].
 */
@PulumiTagMarker
public class MigrateProjectArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var location: Output<String>? = null

    private var migrateProjectName: Output<String>? = null

    private var properties: Output<MigrateProjectPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<MigrateProjectTagsArgs>? = null

    /**
     * @param value Gets or sets the eTag for concurrency control.
     */
    @JvmName("hgtvnasfibtbegml")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Gets or sets the Azure location in which migrate project is created.
     */
    @JvmName("qtnwqokvxwlqnrmo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("qhrjoxjbcelaqogq")
    public suspend fun migrateProjectName(`value`: Output<String>) {
        this.migrateProjectName = value
    }

    /**
     * @param value Gets or sets the nested properties.
     */
    @JvmName("dtsmplbwpbmbcxxk")
    public suspend fun properties(`value`: Output<MigrateProjectPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that migrate project is part of.
     */
    @JvmName("xtcrtqwnlyrufuhp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Gets or sets the tags.
     */
    @JvmName("uythqafgyiwphoeg")
    public suspend fun tags(`value`: Output<MigrateProjectTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the eTag for concurrency control.
     */
    @JvmName("qpfsrnwdwuvccukp")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Gets or sets the Azure location in which migrate project is created.
     */
    @JvmName("lylekjqvdlggoqri")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("tuugiafxlcekdqxk")
    public suspend fun migrateProjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Gets or sets the nested properties.
     */
    @JvmName("vgwkveackbiycyfi")
    public suspend fun properties(`value`: MigrateProjectPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Gets or sets the nested properties.
     */
    @JvmName("yucwmvoupmiqqume")
    public suspend fun properties(argument: suspend MigrateProjectPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateProjectPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that migrate project is part of.
     */
    @JvmName("rubkptmdlaixrphn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the tags.
     */
    @JvmName("ghqdjnyylgdlpvcs")
    public suspend fun tags(`value`: MigrateProjectTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument Gets or sets the tags.
     */
    @JvmName("mgsnijuhwsgxxylg")
    public suspend fun tags(argument: suspend MigrateProjectTagsArgsBuilder.() -> Unit) {
        val toBeMapped = MigrateProjectTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    internal fun build(): MigrateProjectArgs = MigrateProjectArgs(
        eTag = eTag,
        location = location,
        migrateProjectName = migrateProjectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
