@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.MigrateProjectPropertiesResponse.Companion.toKotlin as migrateProjectPropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MigrateProjectsControllerMigrateProject].
 */
@PulumiTagMarker
public class MigrateProjectsControllerMigrateProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MigrateProjectsControllerMigrateProjectArgs =
        MigrateProjectsControllerMigrateProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend MigrateProjectsControllerMigrateProjectArgsBuilder.() -> Unit) {
        val builder = MigrateProjectsControllerMigrateProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MigrateProjectsControllerMigrateProject {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MigrateProjectsControllerMigrateProject(builtJavaResource)
    }
}

/**
 * Migrate project.
 * Azure REST API version: 2020-05-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### MigrateProject_Put
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var migrateProjectsControllerMigrateProject = new AzureNative.Migrate.MigrateProjectsControllerMigrateProject("migrateProjectsControllerMigrateProject", new()
 *     {
 *         Location = "eastus",
 *         MigrateProjectName = "projTest1",
 *         Properties = new AzureNative.Migrate.Inputs.MigrateProjectPropertiesArgs
 *         {
 *             PublicNetworkAccess = "Enabled",
 *         },
 *         ResourceGroupName = "pajindTest1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMigrateProjectsControllerMigrateProject(ctx, "migrateProjectsControllerMigrateProject", &migrate.MigrateProjectsControllerMigrateProjectArgs{
 * 			Location:           pulumi.String("eastus"),
 * 			MigrateProjectName: pulumi.String("projTest1"),
 * 			Properties: &migrate.MigrateProjectPropertiesArgs{
 * 				PublicNetworkAccess: pulumi.String("Enabled"),
 * 			},
 * 			ResourceGroupName: pulumi.String("pajindTest1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject;
 * import com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProjectArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var migrateProjectsControllerMigrateProject = new MigrateProjectsControllerMigrateProject("migrateProjectsControllerMigrateProject", MigrateProjectsControllerMigrateProjectArgs.builder()
 *             .location("eastus")
 *             .migrateProjectName("projTest1")
 *             .properties(Map.of("publicNetworkAccess", "Enabled"))
 *             .resourceGroupName("pajindTest1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MigrateProjectsControllerMigrateProject proj90 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/migrateProjects/{migrateProjectName}
 * ```
 */
public class MigrateProjectsControllerMigrateProject internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject,
) : KotlinCustomResource(javaResource, MigrateProjectsControllerMigrateProjectMapper) {
    /**
     * For optimistic concurrency control.
     */
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure location in which project is created.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of a migrate project.
     */
    public val properties: Output<MigrateProjectPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                migrateProjectPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Type of the object = [Microsoft&#46;Migrate/migrateProjects].
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MigrateProjectsControllerMigrateProjectMapper :
    ResourceMapper<MigrateProjectsControllerMigrateProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject::class == javaResource::class

    override fun map(javaResource: Resource): MigrateProjectsControllerMigrateProject =
        MigrateProjectsControllerMigrateProject(
            javaResource as
                com.pulumi.azurenative.migrate.MigrateProjectsControllerMigrateProject,
        )
}

/**
 * @see [MigrateProjectsControllerMigrateProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MigrateProjectsControllerMigrateProject].
 */
public suspend fun migrateProjectsControllerMigrateProject(
    name: String,
    block: suspend MigrateProjectsControllerMigrateProjectResourceBuilder.() -> Unit,
):
    MigrateProjectsControllerMigrateProject {
    val builder = MigrateProjectsControllerMigrateProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MigrateProjectsControllerMigrateProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun migrateProjectsControllerMigrateProject(name: String):
    MigrateProjectsControllerMigrateProject {
    val builder = MigrateProjectsControllerMigrateProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
