@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourcePropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.MoveResourcePropertiesResponse.Companion.toKotlin as moveResourcePropertiesResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MoveResource].
 */
@PulumiTagMarker
public class MoveResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MoveResourceArgs = MoveResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MoveResourceArgsBuilder.() -> Unit) {
        val builder = MoveResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MoveResource {
        val builtJavaResource = com.pulumi.azurenative.migrate.MoveResource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MoveResource(builtJavaResource)
    }
}

/**
 * Defines the move resource.
 * Azure REST API version: 2022-08-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### MoveResources_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var moveResource = new AzureNative.Migrate.MoveResource("moveResource", new()
 *     {
 *         MoveCollectionName = "movecollection1",
 *         MoveResourceName = "moveresourcename1",
 *         Properties = new AzureNative.Migrate.Inputs.MoveResourcePropertiesArgs
 *         {
 *             DependsOnOverrides = new[]
 *             {
 *                 new AzureNative.Migrate.Inputs.MoveResourceDependencyOverrideArgs
 *                 {
 *                     Id = "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140",
 *                     TargetId = "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140",
 *                 },
 *             },
 *             ResourceSettings = new AzureNative.Migrate.Inputs.VirtualMachineResourceSettingsArgs
 *             {
 *                 ResourceType = "Microsoft.Compute/virtualMachines",
 *                 TargetAvailabilitySetId = "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1",
 *                 TargetAvailabilityZone = "2",
 *                 TargetResourceName = "westusvm1",
 *                 UserManagedIdentities = new[]
 *                 {
 *                     "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1",
 *                 },
 *             },
 *             SourceId = "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1",
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewMoveResource(ctx, "moveResource", &migrate.MoveResourceArgs{
 * 			MoveCollectionName: pulumi.String("movecollection1"),
 * 			MoveResourceName:   pulumi.String("moveresourcename1"),
 * 			Properties: migrate.MoveResourcePropertiesResponse{
 * 				DependsOnOverrides: migrate.MoveResourceDependencyOverrideArray{
 * 					&migrate.MoveResourceDependencyOverrideArgs{
 * 						Id:       pulumi.String("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 * 						TargetId: pulumi.String("/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 * 					},
 * 				},
 * 				ResourceSettings: migrate.VirtualMachineResourceSettings{
 * 					ResourceType:            "Microsoft.Compute/virtualMachines",
 * 					TargetAvailabilitySetId: "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1",
 * 					TargetAvailabilityZone:  "2",
 * 					TargetResourceName:      "westusvm1",
 * 					UserManagedIdentities: []string{
 * 						"/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1",
 * 					},
 * 				},
 * 				SourceId: pulumi.String("/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.MoveResource;
 * import com.pulumi.azurenative.migrate.MoveResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var moveResource = new MoveResource("moveResource", MoveResourceArgs.builder()
 *             .moveCollectionName("movecollection1")
 *             .moveResourceName("moveresourcename1")
 *             .properties(Map.ofEntries(
 *                 Map.entry("dependsOnOverrides", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/eastusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140"),
 *                     Map.entry("targetId", "/subscriptions/c4488a3f-a7f7-4ad4-aa72-0e1f4d9c0756/resourceGroups/westusRG/providers/Microsoft.Network/networkInterfaces/eastusvm140")
 *                 )),
 *                 Map.entry("resourceSettings", Map.ofEntries(
 *                     Map.entry("resourceType", "Microsoft.Compute/virtualMachines"),
 *                     Map.entry("targetAvailabilitySetId", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/availabilitySets/avset1"),
 *                     Map.entry("targetAvailabilityZone", "2"),
 *                     Map.entry("targetResourceName", "westusvm1"),
 *                     Map.entry("userManagedIdentities", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi1")
 *                 )),
 *                 Map.entry("sourceId", "/subscriptions/subid/resourceGroups/eastusRG/providers/Microsoft.Compute/virtualMachines/eastusvm1")
 *             ))
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:MoveResource moveresourcename1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/moveCollections/{moveCollectionName}/moveResources/{moveResourceName}
 * ```
 */
public class MoveResource internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.MoveResource,
) : KotlinCustomResource(javaResource, MoveResourceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Defines the move resource properties.
     */
    public val properties: Output<MoveResourcePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                moveResourcePropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MoveResourceMapper : ResourceMapper<MoveResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.MoveResource::class == javaResource::class

    override fun map(javaResource: Resource): MoveResource = MoveResource(
        javaResource as
            com.pulumi.azurenative.migrate.MoveResource,
    )
}

/**
 * @see [MoveResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MoveResource].
 */
public suspend fun moveResource(
    name: String,
    block: suspend MoveResourceResourceBuilder.() -> Unit,
): MoveResource {
    val builder = MoveResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MoveResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun moveResource(name: String): MoveResource {
    val builder = MoveResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
