@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.PrivateEndpointConnectionPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.PrivateEndpointConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A private endpoint connection for a project.
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### PrivateEndpointConnections_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Migrate.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ETag = "\"00009300-0000-0300-0000-602b967b0000\"",
 *         PrivateEndpointConnectionName = "custestpece80project3980pe.7e35576b-3df4-478e-9759-f64351cf4f43",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.PrivateEndpointConnectionPropertiesArgs
 *         {
 *             PrivateLinkServiceConnectionState = new AzureNative.Migrate.Inputs.PrivateLinkServiceConnectionStateArgs
 *             {
 *                 ActionsRequired = "",
 *                 Status = "Approved",
 *             },
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &migrate.PrivateEndpointConnectionArgs{
 * 			ETag:                          pulumi.String("\"00009300-0000-0300-0000-602b967b0000\""),
 * 			PrivateEndpointConnectionName: pulumi.String("custestpece80project3980pe.7e35576b-3df4-478e-9759-f64351cf4f43"),
 * 			ProjectName:                   pulumi.String("abgoyalWEselfhostb72bproject"),
 * 			Properties: migrate.PrivateEndpointConnectionPropertiesResponse{
 * 				PrivateLinkServiceConnectionState: &migrate.PrivateLinkServiceConnectionStateArgs{
 * 					ActionsRequired: pulumi.String(""),
 * 					Status:          pulumi.String("Approved"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnection;
 * import com.pulumi.azurenative.migrate.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .eTag("\"00009300-0000-0300-0000-602b967b0000\"")
 *             .privateEndpointConnectionName("custestpece80project3980pe.7e35576b-3df4-478e-9759-f64351cf4f43")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(Map.of("privateLinkServiceConnectionState", Map.ofEntries(
 *                 Map.entry("actionsRequired", ""),
 *                 Map.entry("status", "Approved")
 *             )))
 *             .resourceGroupName("abgoyal-westEurope")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:PrivateEndpointConnection custestpece80project3980pe.7e35576b-3df4-478e-9759-f64351cf4f43 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentprojects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property eTag For optimistic concurrency control.
 * @property privateEndpointConnectionName Unique name of a private endpoint connection within a project.
 * @property projectName Name of the Azure Migrate project.
 * @property properties Properties of the private endpoint endpoint connection.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class PrivateEndpointConnectionArgs(
    public val eTag: Output<String>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.migrate.PrivateEndpointConnectionArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<PrivateEndpointConnectionPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("lfllcmnxwjhdgphg")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Unique name of a private endpoint connection within a project.
     */
    @JvmName("fijmpsaomhjgqigw")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("tcrobjfgiupqhlpt")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Properties of the private endpoint endpoint connection.
     */
    @JvmName("cpyvihcagnuoexve")
    public suspend fun properties(`value`: Output<PrivateEndpointConnectionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("aowifcagottqexfu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value For optimistic concurrency control.
     */
    @JvmName("kvibyshhbcpkotrp")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Unique name of a private endpoint connection within a project.
     */
    @JvmName("lejugjbomctuupbr")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("kwpffiugbwgecldk")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Properties of the private endpoint endpoint connection.
     */
    @JvmName("tifijltbmglukikr")
    public suspend fun properties(`value`: PrivateEndpointConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the private endpoint endpoint connection.
     */
    @JvmName("xjlndqnnxheuglrs")
    public suspend
    fun properties(argument: suspend PrivateEndpointConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("uhcwbqecjfshfcnh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        eTag = eTag,
        privateEndpointConnectionName = privateEndpointConnectionName,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
