@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.ServerCollectorArgs.builder
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgs
import com.pulumi.azurenative.migrate.kotlin.inputs.CollectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### ServerCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverCollector = new AzureNative.Migrate.ServerCollector("serverCollector", new()
 *     {
 *         ETag = "\"00000606-0000-0d00-0000-605999bf0000\"",
 *         ProjectName = "app11141project",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "ad9f701a-cc08-4421-b51f-b5762d58e9ba",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "b4975e42-9248-4a36-b99f-37eca377ea00",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site",
 *         },
 *         ResourceGroupName = "pajindtest",
 *         ServerCollectorName = "app23df4collector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewServerCollector(ctx, "serverCollector", &migrate.ServerCollectorArgs{
 * ETag: pulumi.String("\"00000606-0000-0d00-0000-605999bf0000\""),
 * ProjectName: pulumi.String("app11141project"),
 * Properties: migrate.CollectorPropertiesResponse{
 * AgentProperties: interface{}{
 * SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * ApplicationId: pulumi.String("ad9f701a-cc08-4421-b51f-b5762d58e9ba"),
 * Audience: pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp"),
 * Authority: pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * ObjectId: pulumi.String("b4975e42-9248-4a36-b99f-37eca377ea00"),
 * TenantId: pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * },
 * },
 * DiscoverySiteId: pulumi.String("/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site"),
 * },
 * ResourceGroupName: pulumi.String("pajindtest"),
 * ServerCollectorName: pulumi.String("app23df4collector"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.ServerCollector;
 * import com.pulumi.azurenative.migrate.ServerCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverCollector = new ServerCollector("serverCollector", ServerCollectorArgs.builder()
 *             .eTag("\"00000606-0000-0d00-0000-605999bf0000\"")
 *             .projectName("app11141project")
 *             .properties(Map.ofEntries(
 *                 Map.entry("agentProperties", Map.of("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "ad9f701a-cc08-4421-b51f-b5762d58e9ba"),
 *                     Map.entry("audience", "https://72f988bf-86f1-41af-91ab-2d7cd011db47/app23df4authandaccessaadapp"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "b4975e42-9248-4a36-b99f-37eca377ea00"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))),
 *                 Map.entry("discoverySiteId", "/subscriptions/4bd2aa0f-2bd2-4d67-91a8-5a4533d58600/resourceGroups/pajindTest/providers/Microsoft.OffAzure/ServerSites/app21141site")
 *             ))
 *             .resourceGroupName("pajindtest")
 *             .serverCollectorName("app23df4collector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:ServerCollector app23df4collector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/servercollectors/{serverCollectorName}
 * ```
 * @property eTag
 * @property projectName Name of the Azure Migrate project.
 * @property properties
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 * @property serverCollectorName Unique name of a Server collector within a project.
 */
public data class ServerCollectorArgs(
    public val eTag: Output<String>? = null,
    public val projectName: Output<String>? = null,
    public val properties: Output<CollectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverCollectorName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.ServerCollectorArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.ServerCollectorArgs =
        com.pulumi.azurenative.migrate.ServerCollectorArgs.builder()
            .eTag(eTag?.applyValue({ args0 -> args0 }))
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverCollectorName(serverCollectorName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerCollectorArgs].
 */
@PulumiTagMarker
public class ServerCollectorArgsBuilder internal constructor() {
    private var eTag: Output<String>? = null

    private var projectName: Output<String>? = null

    private var properties: Output<CollectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverCollectorName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("lfldietxkppajvgg")
    public suspend fun eTag(`value`: Output<String>) {
        this.eTag = value
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("lymobuwujxwagvsw")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value
     */
    @JvmName("kailufvewrdbhivi")
    public suspend fun properties(`value`: Output<CollectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("letyuychyclnamks")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Unique name of a Server collector within a project.
     */
    @JvmName("giemclowefycdgwe")
    public suspend fun serverCollectorName(`value`: Output<String>) {
        this.serverCollectorName = value
    }

    /**
     * @param value
     */
    @JvmName("wormafycdscttyoy")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eTag = mapped
    }

    /**
     * @param value Name of the Azure Migrate project.
     */
    @JvmName("apotqecmfucuehse")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value
     */
    @JvmName("dxpdudqpsyxtmnwr")
    public suspend fun properties(`value`: CollectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jspgaddpsrtyxpob")
    public suspend fun properties(argument: suspend CollectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("uugruncmocapngmh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Unique name of a Server collector within a project.
     */
    @JvmName("lpolhipsbrjaxcga")
    public suspend fun serverCollectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverCollectorName = mapped
    }

    internal fun build(): ServerCollectorArgs = ServerCollectorArgs(
        eTag = eTag,
        projectName = projectName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        serverCollectorName = serverCollectorName,
    )
}
