@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlDbSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlMiSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlVmSettingsResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.migrate.kotlin.outputs.EntityUptimeResponse.Companion.toKotlin as entityUptimeResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlDbSettingsResponse.Companion.toKotlin as sqlDbSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlMiSettingsResponse.Companion.toKotlin as sqlMiSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SqlVmSettingsResponse.Companion.toKotlin as sqlVmSettingsResponseToKotlin
import com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlAssessmentV2Operation].
 */
@PulumiTagMarker
public class SqlAssessmentV2OperationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlAssessmentV2OperationArgs = SqlAssessmentV2OperationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlAssessmentV2OperationArgsBuilder.() -> Unit) {
        val builder = SqlAssessmentV2OperationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlAssessmentV2Operation {
        val builtJavaResource =
            com.pulumi.azurenative.migrate.SqlAssessmentV2Operation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlAssessmentV2Operation(builtJavaResource)
    }
}

/**
 * SQL Assessment REST resource.
 * Azure REST API version: 2023-03-15.
 * ## Example Usage
 * ### SqlAssessmentV2Operations_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlAssessmentV2Operation = new AzureNative.Migrate.SqlAssessmentV2Operation("sqlAssessmentV2Operation", new()
 *     {
 *         AssessmentName = "test_swagger_1",
 *         AsyncCommitModeIntent = "DisasterRecovery",
 *         AzureLocation = "SoutheastAsia",
 *         AzureOfferCode = "MSAZR0003P",
 *         AzureOfferCodeForVm = "MSAZR0003P",
 *         AzureSqlDatabaseSettings = new AzureNative.Migrate.Inputs.SqlDbSettingsArgs
 *         {
 *             AzureSqlComputeTier = "Automatic",
 *             AzureSqlDataBaseType = "SingleDatabase",
 *             AzureSqlPurchaseModel = "VCore",
 *             AzureSqlServiceTier = "Automatic",
 *         },
 *         AzureSqlManagedInstanceSettings = new AzureNative.Migrate.Inputs.SqlMiSettingsArgs
 *         {
 *             AzureSqlInstanceType = "SingleInstance",
 *             AzureSqlServiceTier = "Automatic",
 *         },
 *         AzureSqlVmSettings = new AzureNative.Migrate.Inputs.SqlVmSettingsArgs
 *         {
 *             InstanceSeries = new[]
 *             {
 *                 "Eadsv5_series",
 *             },
 *         },
 *         Currency = "USD",
 *         DisasterRecoveryLocation = "EastAsia",
 *         DiscountPercentage = 0,
 *         EnableHadrAssessment = true,
 *         EntityUptime = new AzureNative.Migrate.Inputs.EntityUptimeArgs
 *         {
 *             DaysPerMonth = 30,
 *             HoursPerDay = 24,
 *         },
 *         EnvironmentType = "Production",
 *         GroupName = "test_fci_hadr",
 *         MultiSubnetIntent = "DisasterRecovery",
 *         OptimizationLogic = "MinimizeCost",
 *         OsLicense = "Unknown",
 *         Percentile = "Percentile95",
 *         ProjectName = "fci-test6904project",
 *         ReservedInstance = "None",
 *         ReservedInstanceForVm = "None",
 *         ResourceGroupName = "rgmigrate",
 *         ScalingFactor = 1,
 *         SizingCriterion = "PerformanceBased",
 *         SqlServerLicense = "Unknown",
 *         TimeRange = "Day",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := migrate.NewSqlAssessmentV2Operation(ctx, "sqlAssessmentV2Operation", &migrate.SqlAssessmentV2OperationArgs{
 * 			AssessmentName:        pulumi.String("test_swagger_1"),
 * 			AsyncCommitModeIntent: pulumi.String("DisasterRecovery"),
 * 			AzureLocation:         pulumi.String("SoutheastAsia"),
 * 			AzureOfferCode:        pulumi.String("MSAZR0003P"),
 * 			AzureOfferCodeForVm:   pulumi.String("MSAZR0003P"),
 * 			AzureSqlDatabaseSettings: &migrate.SqlDbSettingsArgs{
 * 				AzureSqlComputeTier:   pulumi.String("Automatic"),
 * 				AzureSqlDataBaseType:  pulumi.String("SingleDatabase"),
 * 				AzureSqlPurchaseModel: pulumi.String("VCore"),
 * 				AzureSqlServiceTier:   pulumi.String("Automatic"),
 * 			},
 * 			AzureSqlManagedInstanceSettings: &migrate.SqlMiSettingsArgs{
 * 				AzureSqlInstanceType: pulumi.String("SingleInstance"),
 * 				AzureSqlServiceTier:  pulumi.String("Automatic"),
 * 			},
 * 			AzureSqlVmSettings: &migrate.SqlVmSettingsArgs{
 * 				InstanceSeries: pulumi.StringArray{
 * 					pulumi.String("Eadsv5_series"),
 * 				},
 * 			},
 * 			Currency:                 pulumi.String("USD"),
 * 			DisasterRecoveryLocation: pulumi.String("EastAsia"),
 * 			DiscountPercentage:       pulumi.Float64(0),
 * 			EnableHadrAssessment:     pulumi.Bool(true),
 * 			EntityUptime: &migrate.EntityUptimeArgs{
 * 				DaysPerMonth: pulumi.Int(30),
 * 				HoursPerDay:  pulumi.Int(24),
 * 			},
 * 			EnvironmentType:       pulumi.String("Production"),
 * 			GroupName:             pulumi.String("test_fci_hadr"),
 * 			MultiSubnetIntent:     pulumi.String("DisasterRecovery"),
 * 			OptimizationLogic:     pulumi.String("MinimizeCost"),
 * 			OsLicense:             pulumi.String("Unknown"),
 * 			Percentile:            pulumi.String("Percentile95"),
 * 			ProjectName:           pulumi.String("fci-test6904project"),
 * 			ReservedInstance:      pulumi.String("None"),
 * 			ReservedInstanceForVm: pulumi.String("None"),
 * 			ResourceGroupName:     pulumi.String("rgmigrate"),
 * 			ScalingFactor:         pulumi.Float64(1),
 * 			SizingCriterion:       pulumi.String("PerformanceBased"),
 * 			SqlServerLicense:      pulumi.String("Unknown"),
 * 			TimeRange:             pulumi.String("Day"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.SqlAssessmentV2Operation;
 * import com.pulumi.azurenative.migrate.SqlAssessmentV2OperationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlAssessmentV2Operation = new SqlAssessmentV2Operation("sqlAssessmentV2Operation", SqlAssessmentV2OperationArgs.builder()
 *             .assessmentName("test_swagger_1")
 *             .asyncCommitModeIntent("DisasterRecovery")
 *             .azureLocation("SoutheastAsia")
 *             .azureOfferCode("MSAZR0003P")
 *             .azureOfferCodeForVm("MSAZR0003P")
 *             .azureSqlDatabaseSettings(Map.ofEntries(
 *                 Map.entry("azureSqlComputeTier", "Automatic"),
 *                 Map.entry("azureSqlDataBaseType", "SingleDatabase"),
 *                 Map.entry("azureSqlPurchaseModel", "VCore"),
 *                 Map.entry("azureSqlServiceTier", "Automatic")
 *             ))
 *             .azureSqlManagedInstanceSettings(Map.ofEntries(
 *                 Map.entry("azureSqlInstanceType", "SingleInstance"),
 *                 Map.entry("azureSqlServiceTier", "Automatic")
 *             ))
 *             .azureSqlVmSettings(Map.of("instanceSeries", "Eadsv5_series"))
 *             .currency("USD")
 *             .disasterRecoveryLocation("EastAsia")
 *             .discountPercentage(0)
 *             .enableHadrAssessment(true)
 *             .entityUptime(Map.ofEntries(
 *                 Map.entry("daysPerMonth", 30),
 *                 Map.entry("hoursPerDay", 24)
 *             ))
 *             .environmentType("Production")
 *             .groupName("test_fci_hadr")
 *             .multiSubnetIntent("DisasterRecovery")
 *             .optimizationLogic("MinimizeCost")
 *             .osLicense("Unknown")
 *             .percentile("Percentile95")
 *             .projectName("fci-test6904project")
 *             .reservedInstance("None")
 *             .reservedInstanceForVm("None")
 *             .resourceGroupName("rgmigrate")
 *             .scalingFactor(1)
 *             .sizingCriterion("PerformanceBased")
 *             .sqlServerLicense("Unknown")
 *             .timeRange("Day")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:SqlAssessmentV2Operation test_swagger_1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/sqlAssessments/{assessmentName}
 * ```
 */
public class SqlAssessmentV2Operation internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.SqlAssessmentV2Operation,
) : KotlinCustomResource(javaResource, SqlAssessmentV2OperationMapper) {
    /**
     * Assessment type of the assessment.
     */
    public val assessmentType: Output<String>?
        get() = javaResource.assessmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets user preference indicating intent of async commit mode.
     */
    public val asyncCommitModeIntent: Output<String>?
        get() = javaResource.asyncCommitModeIntent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Location or Azure region where to which the machines will be migrated.
     */
    public val azureLocation: Output<String>?
        get() = javaResource.azureLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Offer Code.
     */
    public val azureOfferCode: Output<String>?
        get() = javaResource.azureOfferCode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets Azure Offer Code for VM.
     */
    public val azureOfferCodeForVm: Output<String>?
        get() = javaResource.azureOfferCodeForVm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating azure security offering type.
     */
    public val azureSecurityOfferingType: Output<String>?
        get() = javaResource.azureSecurityOfferingType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable SQL database settings.
     */
    public val azureSqlDatabaseSettings: Output<SqlDbSettingsResponse>?
        get() = javaResource.azureSqlDatabaseSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sqlDbSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable SQL managed instance settings.
     */
    public val azureSqlManagedInstanceSettings: Output<SqlMiSettingsResponse>?
        get() = javaResource.azureSqlManagedInstanceSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sqlMiSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable SQL VM settings.
     */
    public val azureSqlVmSettings: Output<SqlVmSettingsResponse>?
        get() = javaResource.azureSqlVmSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> sqlVmSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Confidence Rating in Percentage.
     */
    public val confidenceRatingInPercentage: Output<Double>?
        get() = javaResource.confidenceRatingInPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and Time when assessment was created.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Currency in which prices should be reported.
     */
    public val currency: Output<String>?
        get() = javaResource.currency().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the Azure Location or Azure region where to which the machines
     * will be migrated.
     */
    public val disasterRecoveryLocation: Output<String>?
        get() = javaResource.disasterRecoveryLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Custom discount percentage.
     */
    public val discountPercentage: Output<Double>?
        get() = javaResource.discountPercentage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the Enterprise agreement subscription id.
     */
    public val eaSubscriptionId: Output<String>?
        get() = javaResource.eaSubscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets a value indicating whether HADR assessments needs to be created.
     */
    public val enableHadrAssessment: Output<Boolean>?
        get() = javaResource.enableHadrAssessment().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the duration for which the entity (SQL, VMs) are up in the
     * on-premises environment.
     */
    public val entityUptime: Output<EntityUptimeResponse>?
        get() = javaResource.entityUptime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    entityUptimeResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable setting to display the environment type.
     */
    public val environmentType: Output<String>?
        get() = javaResource.environmentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets the group type for the assessment.
     */
    public val groupType: Output<String>?
        get() = javaResource.groupType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets a value indicating whether internet access is available.
     */
    public val isInternetAccessAvailable: Output<Boolean>?
        get() = javaResource.isInternetAccessAvailable().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets user preference indicating intent of multi-subnet configuration.
     */
    public val multiSubnetIntent: Output<String>?
        get() = javaResource.multiSubnetIntent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets or sets SQL optimization logic.
     */
    public val optimizationLogic: Output<String>?
        get() = javaResource.optimizationLogic().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets user configurable setting to display the azure hybrid use benefit.
     */
    public val osLicense: Output<String>?
        get() = javaResource.osLicense().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Percentile of the utilization data values to be considered while assessing
     * machines.
     */
    public val percentile: Output<String>?
        get() = javaResource.percentile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the end time to consider performance data for assessment.
     */
    public val perfDataEndTime: Output<String>?
        get() = javaResource.perfDataEndTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the start time to consider performance data for assessment.
     */
    public val perfDataStartTime: Output<String>?
        get() = javaResource.perfDataStartTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Last time when rates were queried.
     */
    public val pricesTimestamp: Output<String>
        get() = javaResource.pricesTimestamp().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Reserved instance.
     */
    public val reservedInstance: Output<String>?
        get() = javaResource.reservedInstance().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets azure reserved instance for VM.
     */
    public val reservedInstanceForVm: Output<String>?
        get() = javaResource.reservedInstanceForVm().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Percentage of buffer that user wants on performance metrics when recommending
     * Azure sizes.
     */
    public val scalingFactor: Output<Double>?
        get() = javaResource.scalingFactor().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Schema version.
     */
    public val schemaVersion: Output<String>
        get() = javaResource.schemaVersion().applyValue({ args0 -> args0 })

    /**
     * Assessment sizing criterion.
     */
    public val sizingCriterion: Output<String>?
        get() = javaResource.sizingCriterion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL server license.
     */
    public val sqlServerLicense: Output<String>?
        get() = javaResource.sqlServerLicense().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User configurable setting to display the Stage of Assessment.
     */
    public val stage: Output<String>
        get() = javaResource.stage().applyValue({ args0 -> args0 })

    /**
     * Whether assessment is in valid state and all machines have been assessed.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Time Range for which the historic utilization data should be considered for
     * assessment.
     */
    public val timeRange: Output<String>?
        get() = javaResource.timeRange().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Date and Time when assessment was last updated.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })
}

public object SqlAssessmentV2OperationMapper : ResourceMapper<SqlAssessmentV2Operation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.SqlAssessmentV2Operation::class == javaResource::class

    override fun map(javaResource: Resource): SqlAssessmentV2Operation =
        SqlAssessmentV2Operation(
            javaResource as
                com.pulumi.azurenative.migrate.SqlAssessmentV2Operation,
        )
}

/**
 * @see [SqlAssessmentV2Operation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlAssessmentV2Operation].
 */
public suspend fun sqlAssessmentV2Operation(
    name: String,
    block: suspend SqlAssessmentV2OperationResourceBuilder.() -> Unit,
): SqlAssessmentV2Operation {
    val builder = SqlAssessmentV2OperationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlAssessmentV2Operation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlAssessmentV2Operation(name: String): SqlAssessmentV2Operation {
    val builder = SqlAssessmentV2OperationResourceBuilder()
    builder.name(name)
    return builder.build()
}
