@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin

import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse
import com.pulumi.azurenative.migrate.kotlin.outputs.CollectorPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [VMwareCollector].
 */
@PulumiTagMarker
public class VMwareCollectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VMwareCollectorArgs = VMwareCollectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VMwareCollectorArgsBuilder.() -> Unit) {
        val builder = VMwareCollectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VMwareCollector {
        val builtJavaResource = com.pulumi.azurenative.migrate.VMwareCollector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VMwareCollector(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2019-10-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * ## Example Usage
 * ### VMwareCollectors_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vMwareCollector = new AzureNative.Migrate.VMwareCollector("vMwareCollector", new()
 *     {
 *         ETag = "\"01003d32-0000-0d00-0000-5d74d2e50000\"",
 *         ProjectName = "abgoyalWEselfhostb72bproject",
 *         Properties = new AzureNative.Migrate.Inputs.CollectorPropertiesArgs
 *         {
 *             AgentProperties = new AzureNative.Migrate.Inputs.CollectorAgentPropertiesArgs
 *             {
 *                 SpnDetails = new AzureNative.Migrate.Inputs.CollectorBodyAgentSpnPropertiesArgs
 *                 {
 *                     ApplicationId = "fc717575-8173-4b21-92a5-658b655e613e",
 *                     Audience = "https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp",
 *                     Authority = "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                     ObjectId = "29d94f38-db94-4980-aec0-0cfd55ab1cd0",
 *                     TenantId = "72f988bf-86f1-41af-91ab-2d7cd011db47",
 *                 },
 *             },
 *             DiscoverySiteId = "/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite",
 *         },
 *         ResourceGroupName = "abgoyal-westEurope",
 *         VmWareCollectorName = "PortalvCenterbc2fcollector",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/migrate/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := migrate.NewVMwareCollector(ctx, "vMwareCollector", &migrate.VMwareCollectorArgs{
 * ETag: pulumi.String("\"01003d32-0000-0d00-0000-5d74d2e50000\""),
 * ProjectName: pulumi.String("abgoyalWEselfhostb72bproject"),
 * Properties: migrate.CollectorPropertiesResponse{
 * AgentProperties: interface{}{
 * SpnDetails: &migrate.CollectorBodyAgentSpnPropertiesArgs{
 * ApplicationId: pulumi.String("fc717575-8173-4b21-92a5-658b655e613e"),
 * Audience: pulumi.String("https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp"),
 * Authority: pulumi.String("https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * ObjectId: pulumi.String("29d94f38-db94-4980-aec0-0cfd55ab1cd0"),
 * TenantId: pulumi.String("72f988bf-86f1-41af-91ab-2d7cd011db47"),
 * },
 * },
 * DiscoverySiteId: pulumi.String("/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite"),
 * },
 * ResourceGroupName: pulumi.String("abgoyal-westEurope"),
 * VmWareCollectorName: pulumi.String("PortalvCenterbc2fcollector"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.migrate.VMwareCollector;
 * import com.pulumi.azurenative.migrate.VMwareCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vMwareCollector = new VMwareCollector("vMwareCollector", VMwareCollectorArgs.builder()
 *             .eTag("\"01003d32-0000-0d00-0000-5d74d2e50000\"")
 *             .projectName("abgoyalWEselfhostb72bproject")
 *             .properties(Map.ofEntries(
 *                 Map.entry("agentProperties", Map.of("spnDetails", Map.ofEntries(
 *                     Map.entry("applicationId", "fc717575-8173-4b21-92a5-658b655e613e"),
 *                     Map.entry("audience", "https://72f988bf-86f1-41af-91ab-2d7cd011db47/PortalvCenterbc2fagentauthaadapp"),
 *                     Map.entry("authority", "https://login.windows.net/72f988bf-86f1-41af-91ab-2d7cd011db47"),
 *                     Map.entry("objectId", "29d94f38-db94-4980-aec0-0cfd55ab1cd0"),
 *                     Map.entry("tenantId", "72f988bf-86f1-41af-91ab-2d7cd011db47")
 *                 ))),
 *                 Map.entry("discoverySiteId", "/subscriptions/6393a73f-8d55-47ef-b6dd-179b3e0c7910/resourceGroups/abgoyal-westEurope/providers/Microsoft.OffAzure/VMwareSites/PortalvCenterbc2fsite")
 *             ))
 *             .resourceGroupName("abgoyal-westEurope")
 *             .vmWareCollectorName("PortalvCenterbc2fcollector")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:migrate:VMwareCollector PortalvCenterbc2fcollector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/vmwarecollectors/{vmWareCollectorName}
 * ```
 */
public class VMwareCollector internal constructor(
    override val javaResource: com.pulumi.azurenative.migrate.VMwareCollector,
) : KotlinCustomResource(javaResource, VMwareCollectorMapper) {
    public val eTag: Output<String>?
        get() = javaResource.eTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<CollectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object VMwareCollectorMapper : ResourceMapper<VMwareCollector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.migrate.VMwareCollector::class == javaResource::class

    override fun map(javaResource: Resource): VMwareCollector = VMwareCollector(
        javaResource as
            com.pulumi.azurenative.migrate.VMwareCollector,
    )
}

/**
 * @see [VMwareCollector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VMwareCollector].
 */
public suspend fun vMwareCollector(
    name: String,
    block: suspend VMwareCollectorResourceBuilder.() -> Unit,
): VMwareCollector {
    val builder = VMwareCollectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VMwareCollector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vMwareCollector(name: String): VMwareCollector {
    val builder = VMwareCollectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
