@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets user configurable setting to display the environment type.
 */
public enum class EnvironmentType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.EnvironmentType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.EnvironmentType> {
    Production(com.pulumi.azurenative.migrate.enums.EnvironmentType.Production),
    Test(com.pulumi.azurenative.migrate.enums.EnvironmentType.Test),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.EnvironmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.EnvironmentType):
            EnvironmentType = EnvironmentType.values().first { it.javaValue == javaType }
    }
}
