@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Failures to tolerate and RAID level in a common property.
 */
public enum class FttAndRaidLevel(
    public val javaValue: com.pulumi.azurenative.migrate.enums.FttAndRaidLevel,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.FttAndRaidLevel> {
    Unknown(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Unknown),
    Ftt1Raid1(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Ftt1Raid1),
    Ftt1Raid5(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Ftt1Raid5),
    Ftt2Raid1(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Ftt2Raid1),
    Ftt2Raid6(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Ftt2Raid6),
    Ftt3Raid1(com.pulumi.azurenative.migrate.enums.FttAndRaidLevel.Ftt3Raid1),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.FttAndRaidLevel = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.FttAndRaidLevel):
            FttAndRaidLevel = FttAndRaidLevel.values().first { it.javaValue == javaType }
    }
}
