@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the goal of the solution.
 */
public enum class Goal(
    public val javaValue: com.pulumi.azurenative.migrate.enums.Goal,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.Goal> {
    Servers(com.pulumi.azurenative.migrate.enums.Goal.Servers),
    Databases(com.pulumi.azurenative.migrate.enums.Goal.Databases),
    DesktopVirtualization(com.pulumi.azurenative.migrate.enums.Goal.DesktopVirtualization),
    WebApplications(com.pulumi.azurenative.migrate.enums.Goal.WebApplications),
    DataCenter(com.pulumi.azurenative.migrate.enums.Goal.DataCenter),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.Goal = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.Goal): Goal =
            Goal.values().first { it.javaValue == javaType }
    }
}
