@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Assessment project status.
 */
public enum class ProjectStatus(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ProjectStatus,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ProjectStatus> {
    Active(com.pulumi.azurenative.migrate.enums.ProjectStatus.Active),
    Inactive(com.pulumi.azurenative.migrate.enums.ProjectStatus.Inactive),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ProjectStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ProjectStatus): ProjectStatus =
            ProjectStatus.values().first { it.javaValue == javaType }
    }
}
