@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of identity used for the resource mover service.
 */
public enum class ResourceIdentityType(
    public val javaValue: com.pulumi.azurenative.migrate.enums.ResourceIdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.ResourceIdentityType> {
    None(com.pulumi.azurenative.migrate.enums.ResourceIdentityType.None),
    SystemAssigned(com.pulumi.azurenative.migrate.enums.ResourceIdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.migrate.enums.ResourceIdentityType.UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.ResourceIdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.ResourceIdentityType):
            ResourceIdentityType = ResourceIdentityType.values().first { it.javaValue == javaType }
    }
}
