@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets or sets the tool being used in the solution.
 */
public enum class Tool(
    public val javaValue: com.pulumi.azurenative.migrate.enums.Tool,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.enums.Tool> {
    ServerDiscovery(com.pulumi.azurenative.migrate.enums.Tool.ServerDiscovery),
    ServerAssessment(com.pulumi.azurenative.migrate.enums.Tool.ServerAssessment),
    ServerMigration(com.pulumi.azurenative.migrate.enums.Tool.ServerMigration),
    Cloudamize(com.pulumi.azurenative.migrate.enums.Tool.Cloudamize),
    Turbonomic(com.pulumi.azurenative.migrate.enums.Tool.Turbonomic),
    Zerto(com.pulumi.azurenative.migrate.enums.Tool.Zerto),
    CorentTech(com.pulumi.azurenative.migrate.enums.Tool.CorentTech),
    ServerAssessmentV1(com.pulumi.azurenative.migrate.enums.Tool.ServerAssessmentV1),
    ServerMigration_Replication(com.pulumi.azurenative.migrate.enums.Tool.ServerMigration_Replication),
    Carbonite(com.pulumi.azurenative.migrate.enums.Tool.Carbonite),
    DataMigrationAssistant(com.pulumi.azurenative.migrate.enums.Tool.DataMigrationAssistant),
    DatabaseMigrationService(com.pulumi.azurenative.migrate.enums.Tool.DatabaseMigrationService),
    Device42(com.pulumi.azurenative.migrate.enums.Tool.Device42),
    JetStream(com.pulumi.azurenative.migrate.enums.Tool.JetStream),
    RackWare(com.pulumi.azurenative.migrate.enums.Tool.RackWare),
    UnifyCloud(com.pulumi.azurenative.migrate.enums.Tool.UnifyCloud),
    Flexera(com.pulumi.azurenative.migrate.enums.Tool.Flexera),
    ServerDiscovery_Import(com.pulumi.azurenative.migrate.enums.Tool.ServerDiscovery_Import),
    Lakeside(com.pulumi.azurenative.migrate.enums.Tool.Lakeside),
    AppServiceMigrationAssistant(com.pulumi.azurenative.migrate.enums.Tool.AppServiceMigrationAssistant),
    Movere(com.pulumi.azurenative.migrate.enums.Tool.Movere),
    CloudSphere(com.pulumi.azurenative.migrate.enums.Tool.CloudSphere),
    Modernization(com.pulumi.azurenative.migrate.enums.Tool.Modernization),
    ServerMigration_DataReplication(com.pulumi.azurenative.migrate.enums.Tool.ServerMigration_DataReplication),
    Unknown(com.pulumi.azurenative.migrate.enums.Tool.Unknown),
    ;

    override fun toJava(): com.pulumi.azurenative.migrate.enums.Tool = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.enums.Tool): Tool =
            Tool.values().first { it.javaValue == javaType }
    }
}
