@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.CertArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.SecretStoreType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * WebApplication certificate.
 * @property certData Gets or sets the Certificate data.
 * @property certNeeded Gets or sets a value indicating whether certificate is needed or not.
 * @property certProvided Gets or sets a value indicating whether certificate is provided or not.
 * @property secretStore Gets or sets the type of secret store for the certificate.
 */
public data class CertArgs(
    public val certData: Output<String>? = null,
    public val certNeeded: Output<Boolean>? = null,
    public val certProvided: Output<Boolean>? = null,
    public val secretStore: Output<Either<String, SecretStoreType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.CertArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.CertArgs =
        com.pulumi.azurenative.migrate.inputs.CertArgs.builder()
            .certData(certData?.applyValue({ args0 -> args0 }))
            .certNeeded(certNeeded?.applyValue({ args0 -> args0 }))
            .certProvided(certProvided?.applyValue({ args0 -> args0 }))
            .secretStore(
                secretStore?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [CertArgs].
 */
@PulumiTagMarker
public class CertArgsBuilder internal constructor() {
    private var certData: Output<String>? = null

    private var certNeeded: Output<Boolean>? = null

    private var certProvided: Output<Boolean>? = null

    private var secretStore: Output<Either<String, SecretStoreType>>? = null

    /**
     * @param value Gets or sets the Certificate data.
     */
    @JvmName("mhgxnluaqsvdfdwy")
    public suspend fun certData(`value`: Output<String>) {
        this.certData = value
    }

    /**
     * @param value Gets or sets a value indicating whether certificate is needed or not.
     */
    @JvmName("oelrsxnjkdyxuqvj")
    public suspend fun certNeeded(`value`: Output<Boolean>) {
        this.certNeeded = value
    }

    /**
     * @param value Gets or sets a value indicating whether certificate is provided or not.
     */
    @JvmName("iupfelwylfocmstf")
    public suspend fun certProvided(`value`: Output<Boolean>) {
        this.certProvided = value
    }

    /**
     * @param value Gets or sets the type of secret store for the certificate.
     */
    @JvmName("ycifkvwrghsotjeh")
    public suspend fun secretStore(`value`: Output<Either<String, SecretStoreType>>) {
        this.secretStore = value
    }

    /**
     * @param value Gets or sets the Certificate data.
     */
    @JvmName("fxiptdwjoqtlvghc")
    public suspend fun certData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certData = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether certificate is needed or not.
     */
    @JvmName("hvulamqrxaswelqm")
    public suspend fun certNeeded(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certNeeded = mapped
    }

    /**
     * @param value Gets or sets a value indicating whether certificate is provided or not.
     */
    @JvmName("ujbojgqnrldvpsjk")
    public suspend fun certProvided(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certProvided = mapped
    }

    /**
     * @param value Gets or sets the type of secret store for the certificate.
     */
    @JvmName("eqemskotvsknupuo")
    public suspend fun secretStore(`value`: Either<String, SecretStoreType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param value Gets or sets the type of secret store for the certificate.
     */
    @JvmName("enwfgdwifnackogr")
    public fun secretStore(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    /**
     * @param value Gets or sets the type of secret store for the certificate.
     */
    @JvmName("yfnfqsyyonmvjmww")
    public fun secretStore(`value`: SecretStoreType) {
        val toBeMapped = Either.ofRight<String, SecretStoreType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretStore = mapped
    }

    internal fun build(): CertArgs = CertArgs(
        certData = certData,
        certNeeded = certNeeded,
        certProvided = certProvided,
        secretStore = secretStore,
    )
}
