@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Collector agent property class.
 * @property id Gets the collector agent id.
 * @property lastHeartbeatUtc Gets the collector last heartbeat time.
 * @property spnDetails Gets or sets the SPN details.
 * @property version Gets the collector agent version.
 */
public data class CollectorAgentPropertiesBaseArgs(
    public val id: Output<String>? = null,
    public val lastHeartbeatUtc: Output<String>? = null,
    public val spnDetails: Output<CollectorAgentSpnPropertiesBaseArgs>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs =
        com.pulumi.azurenative.migrate.inputs.CollectorAgentPropertiesBaseArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .lastHeartbeatUtc(lastHeartbeatUtc?.applyValue({ args0 -> args0 }))
            .spnDetails(spnDetails?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollectorAgentPropertiesBaseArgs].
 */
@PulumiTagMarker
public class CollectorAgentPropertiesBaseArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var lastHeartbeatUtc: Output<String>? = null

    private var spnDetails: Output<CollectorAgentSpnPropertiesBaseArgs>? = null

    private var version: Output<String>? = null

    /**
     * @param value Gets the collector agent id.
     */
    @JvmName("osmrhbsjubneibon")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets the collector last heartbeat time.
     */
    @JvmName("monwcukavdyvpixn")
    public suspend fun lastHeartbeatUtc(`value`: Output<String>) {
        this.lastHeartbeatUtc = value
    }

    /**
     * @param value Gets or sets the SPN details.
     */
    @JvmName("uegcbdkxemwwqbst")
    public suspend fun spnDetails(`value`: Output<CollectorAgentSpnPropertiesBaseArgs>) {
        this.spnDetails = value
    }

    /**
     * @param value Gets the collector agent version.
     */
    @JvmName("jfmmxliucckdwkbk")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets the collector agent id.
     */
    @JvmName("cclapchmvjwcyjuv")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets the collector last heartbeat time.
     */
    @JvmName("lbsvyqkwqwboxpjg")
    public suspend fun lastHeartbeatUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastHeartbeatUtc = mapped
    }

    /**
     * @param value Gets or sets the SPN details.
     */
    @JvmName("gdhwauabjuyjcftn")
    public suspend fun spnDetails(`value`: CollectorAgentSpnPropertiesBaseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spnDetails = mapped
    }

    /**
     * @param argument Gets or sets the SPN details.
     */
    @JvmName("jhjtxmlhllvwihew")
    public suspend
    fun spnDetails(argument: suspend CollectorAgentSpnPropertiesBaseArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentSpnPropertiesBaseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spnDetails = mapped
    }

    /**
     * @param value Gets the collector agent version.
     */
    @JvmName("vduaaurtplhiridr")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): CollectorAgentPropertiesBaseArgs = CollectorAgentPropertiesBaseArgs(
        id = id,
        lastHeartbeatUtc = lastHeartbeatUtc,
        spnDetails = spnDetails,
        version = version,
    )
}
