@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property agentProperties
 * @property discoverySiteId The ARM id of the discovery service site.
 */
public data class CollectorPropertiesArgs(
    public val agentProperties: Output<CollectorAgentPropertiesArgs>? = null,
    public val discoverySiteId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.CollectorPropertiesArgs.builder()
            .agentProperties(agentProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .discoverySiteId(discoverySiteId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CollectorPropertiesArgs].
 */
@PulumiTagMarker
public class CollectorPropertiesArgsBuilder internal constructor() {
    private var agentProperties: Output<CollectorAgentPropertiesArgs>? = null

    private var discoverySiteId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("xhyqsrcpayhsghtk")
    public suspend fun agentProperties(`value`: Output<CollectorAgentPropertiesArgs>) {
        this.agentProperties = value
    }

    /**
     * @param value The ARM id of the discovery service site.
     */
    @JvmName("gabvjdprowelnwnc")
    public suspend fun discoverySiteId(`value`: Output<String>) {
        this.discoverySiteId = value
    }

    /**
     * @param value
     */
    @JvmName("txdxvrolwgrmlfos")
    public suspend fun agentProperties(`value`: CollectorAgentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.agentProperties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fdspmnqgpqevvkkf")
    public suspend
    fun agentProperties(argument: suspend CollectorAgentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CollectorAgentPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.agentProperties = mapped
    }

    /**
     * @param value The ARM id of the discovery service site.
     */
    @JvmName("ugsnbnjhxipyfvxv")
    public suspend fun discoverySiteId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.discoverySiteId = mapped
    }

    internal fun build(): CollectorPropertiesArgs = CollectorPropertiesArgs(
        agentProperties = agentProperties,
        discoverySiteId = discoverySiteId,
    )
}
