@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.DirectoryPathArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Second level entity for virtual directories.
 * @property physical Gets or sets the physical path of the directory on the web server.
 * @property virtual Gets or sets the virtual path for the directory.
 */
public data class DirectoryPathArgs(
    public val physical: Output<String>? = null,
    public val virtual: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.DirectoryPathArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.DirectoryPathArgs =
        com.pulumi.azurenative.migrate.inputs.DirectoryPathArgs.builder()
            .physical(physical?.applyValue({ args0 -> args0 }))
            .virtual(virtual?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryPathArgs].
 */
@PulumiTagMarker
public class DirectoryPathArgsBuilder internal constructor() {
    private var physical: Output<String>? = null

    private var virtual: Output<String>? = null

    /**
     * @param value Gets or sets the physical path of the directory on the web server.
     */
    @JvmName("ltdllrajdbiytvtx")
    public suspend fun physical(`value`: Output<String>) {
        this.physical = value
    }

    /**
     * @param value Gets or sets the virtual path for the directory.
     */
    @JvmName("edfvbwttlatagrmh")
    public suspend fun virtual(`value`: Output<String>) {
        this.virtual = value
    }

    /**
     * @param value Gets or sets the physical path of the directory on the web server.
     */
    @JvmName("kwtjqecvkmjxbunk")
    public suspend fun physical(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physical = mapped
    }

    /**
     * @param value Gets or sets the virtual path for the directory.
     */
    @JvmName("ohifjeroptxwbctb")
    public suspend fun virtual(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtual = mapped
    }

    internal fun build(): DirectoryPathArgs = DirectoryPathArgs(
        physical = physical,
        virtual = virtual,
    )
}
