@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetAssessmentProjectsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetAssessmentProjectsOperationPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetAssessmentProjectsOperationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.GetAssessmentProjectsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetAssessmentProjectsOperationPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAssessmentProjectsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetAssessmentProjectsOperationPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ujopwinseywpejxm")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gitfrkaihpstyjnb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAssessmentProjectsOperationPlainArgs =
        GetAssessmentProjectsOperationPlainArgs(
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
