@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrateProjectName Migrate project name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetMigrateProjectsControllerMigrateProjectPlainArgs(
    public val migrateProjectName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetMigrateProjectsControllerMigrateProjectPlainArgs.builder()
            .migrateProjectName(migrateProjectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrateProjectsControllerMigrateProjectPlainArgs].
 */
@PulumiTagMarker
public class GetMigrateProjectsControllerMigrateProjectPlainArgsBuilder internal constructor() {
    private var migrateProjectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Migrate project name.
     */
    @JvmName("fnjgfedyfpsyidtc")
    public suspend fun migrateProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("uwcsuoyahcsvjkli")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMigrateProjectsControllerMigrateProjectPlainArgs =
        GetMigrateProjectsControllerMigrateProjectPlainArgs(
            migrateProjectName = migrateProjectName ?: throw PulumiNullFieldException("migrateProjectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
