@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property migrateProjectName Migrate project name.
 * @property peConnectionName Private endpoint connection name.
 * @property resourceGroupName Name of the Azure Resource Group that project is part of.
 */
public data class GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs(
    public val migrateProjectName: String,
    public val peConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs.builder()
            .migrateProjectName(migrateProjectName.let({ args0 -> args0 }))
            .peConnectionName(peConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgsBuilder
internal constructor() {
    private var migrateProjectName: String? = null

    private var peConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Migrate project name.
     */
    @JvmName("xglkpewflepcpdqh")
    public suspend fun migrateProjectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.migrateProjectName = mapped
    }

    /**
     * @param value Private endpoint connection name.
     */
    @JvmName("nlanuetlcpexcjln")
    public suspend fun peConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.peConnectionName = mapped
    }

    /**
     * @param value Name of the Azure Resource Group that project is part of.
     */
    @JvmName("ybminlljlthhntyq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionControllerPrivateEndpointConnectionPlainArgs(
            migrateProjectName = migrateProjectName ?: throw PulumiNullFieldException("migrateProjectName"),
            peConnectionName = peConnectionName ?: throw PulumiNullFieldException("peConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
