@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetServerCollectorsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverCollectorName Physical server collector ARM name
 */
public data class GetServerCollectorsOperationPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
    public val serverCollectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetServerCollectorsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetServerCollectorsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetServerCollectorsOperationPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverCollectorName(serverCollectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerCollectorsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetServerCollectorsOperationPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var serverCollectorName: String? = null

    /**
     * @param value Assessment Project Name
     */
    @JvmName("ryxoiqbkuhrfhaky")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lfwpvddbfyejxmdl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Physical server collector ARM name
     */
    @JvmName("cxcbusehqjhdwxjc")
    public suspend fun serverCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverCollectorName = mapped
    }

    internal fun build(): GetServerCollectorsOperationPlainArgs =
        GetServerCollectorsOperationPlainArgs(
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            serverCollectorName = serverCollectorName ?: throw PulumiNullFieldException("serverCollectorName"),
        )
}
