@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.GetVmwareCollectorsOperationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property projectName Assessment Project Name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property vmWareCollectorName VMware collector ARM name
 */
public data class GetVmwareCollectorsOperationPlainArgs(
    public val projectName: String,
    public val resourceGroupName: String,
    public val vmWareCollectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.GetVmwareCollectorsOperationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.GetVmwareCollectorsOperationPlainArgs =
        com.pulumi.azurenative.migrate.inputs.GetVmwareCollectorsOperationPlainArgs.builder()
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmWareCollectorName(vmWareCollectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVmwareCollectorsOperationPlainArgs].
 */
@PulumiTagMarker
public class GetVmwareCollectorsOperationPlainArgsBuilder internal constructor() {
    private var projectName: String? = null

    private var resourceGroupName: String? = null

    private var vmWareCollectorName: String? = null

    /**
     * @param value Assessment Project Name
     */
    @JvmName("vcyrodepymxpemmd")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("poaefvreosiocyqc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value VMware collector ARM name
     */
    @JvmName("ueyrqgqurxmboool")
    public suspend fun vmWareCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmWareCollectorName = mapped
    }

    internal fun build(): GetVmwareCollectorsOperationPlainArgs =
        GetVmwareCollectorsOperationPlainArgs(
            projectName = projectName ?: throw PulumiNullFieldException("projectName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmWareCollectorName = vmWareCollectorName ?: throw PulumiNullFieldException("vmWareCollectorName"),
        )
}
