@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.IISVirtualApplicationDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * IIS virtual application details.
 * @property directories Gets or sets the list of directories.
 * @property path Second level entity for virtual directories.
 */
public data class IISVirtualApplicationDetailsArgs(
    public val directories: Output<List<DirectoryPathArgs>>? = null,
    public val path: Output<DirectoryPathArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.IISVirtualApplicationDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.IISVirtualApplicationDetailsArgs =
        com.pulumi.azurenative.migrate.inputs.IISVirtualApplicationDetailsArgs.builder()
            .directories(
                directories?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IISVirtualApplicationDetailsArgs].
 */
@PulumiTagMarker
public class IISVirtualApplicationDetailsArgsBuilder internal constructor() {
    private var directories: Output<List<DirectoryPathArgs>>? = null

    private var path: Output<DirectoryPathArgs>? = null

    /**
     * @param value Gets or sets the list of directories.
     */
    @JvmName("etxqkwjlhxjpmxjt")
    public suspend fun directories(`value`: Output<List<DirectoryPathArgs>>) {
        this.directories = value
    }

    @JvmName("dsqwbrdwhafphtra")
    public suspend fun directories(vararg values: Output<DirectoryPathArgs>) {
        this.directories = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the list of directories.
     */
    @JvmName("uokcrdcnwybnkghn")
    public suspend fun directories(values: List<Output<DirectoryPathArgs>>) {
        this.directories = Output.all(values)
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("uxbuchmrafhcroum")
    public suspend fun path(`value`: Output<DirectoryPathArgs>) {
        this.path = value
    }

    /**
     * @param value Gets or sets the list of directories.
     */
    @JvmName("rxtjrvmpvfcikueo")
    public suspend fun directories(`value`: List<DirectoryPathArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("vdsobvkjwobgurto")
    public suspend fun directories(argument: List<suspend DirectoryPathArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DirectoryPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("tjcbpksxdhjsypmq")
    public suspend fun directories(vararg argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DirectoryPathArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param argument Gets or sets the list of directories.
     */
    @JvmName("xlnalreeihmawylf")
    public suspend fun directories(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DirectoryPathArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.directories = mapped
    }

    /**
     * @param values Gets or sets the list of directories.
     */
    @JvmName("hfptijhstbhndsmo")
    public suspend fun directories(vararg values: DirectoryPathArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.directories = mapped
    }

    /**
     * @param value Second level entity for virtual directories.
     */
    @JvmName("txrdmktphqfnckxk")
    public suspend fun path(`value`: DirectoryPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param argument Second level entity for virtual directories.
     */
    @JvmName("xnbtuxdcydkeexum")
    public suspend fun path(argument: suspend DirectoryPathArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryPathArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.path = mapped
    }

    internal fun build(): IISVirtualApplicationDetailsArgs = IISVirtualApplicationDetailsArgs(
        directories = directories,
        path = path,
    )
}
