@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LBFrontendIPConfigurationResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines load balancer frontend IP configuration properties.
 * @property name Gets or sets the frontend IP configuration name.
 * @property privateIpAddress Gets or sets the IP address of the Load Balancer.This is only specified if a specific
 * private IP address shall be allocated from the subnet specified in subnetRef.
 * @property privateIpAllocationMethod Gets or sets PrivateIP allocation method (Static/Dynamic).
 * @property subnet Defines reference to subnet.
 * @property zones Gets or sets the csv list of zones.
 */
public data class LBFrontendIPConfigurationResourceSettingsArgs(
    public val name: Output<String>? = null,
    public val privateIpAddress: Output<String>? = null,
    public val privateIpAllocationMethod: Output<String>? = null,
    public val subnet: Output<SubnetReferenceArgs>? = null,
    public val zones: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LBFrontendIPConfigurationResourceSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.migrate.inputs.LBFrontendIPConfigurationResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.LBFrontendIPConfigurationResourceSettingsArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .privateIpAddress(privateIpAddress?.applyValue({ args0 -> args0 }))
            .privateIpAllocationMethod(privateIpAllocationMethod?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .zones(zones?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LBFrontendIPConfigurationResourceSettingsArgs].
 */
@PulumiTagMarker
public class LBFrontendIPConfigurationResourceSettingsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var privateIpAddress: Output<String>? = null

    private var privateIpAllocationMethod: Output<String>? = null

    private var subnet: Output<SubnetReferenceArgs>? = null

    private var zones: Output<String>? = null

    /**
     * @param value Gets or sets the frontend IP configuration name.
     */
    @JvmName("qlqfqhiobukmqgoc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets or sets the IP address of the Load Balancer.This is only specified if a specific
     * private IP address shall be allocated from the subnet specified in subnetRef.
     */
    @JvmName("jxijqbirbdyiodud")
    public suspend fun privateIpAddress(`value`: Output<String>) {
        this.privateIpAddress = value
    }

    /**
     * @param value Gets or sets PrivateIP allocation method (Static/Dynamic).
     */
    @JvmName("rbpkdshfqsubijff")
    public suspend fun privateIpAllocationMethod(`value`: Output<String>) {
        this.privateIpAllocationMethod = value
    }

    /**
     * @param value Defines reference to subnet.
     */
    @JvmName("taytyhxoumtxuocg")
    public suspend fun subnet(`value`: Output<SubnetReferenceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Gets or sets the csv list of zones.
     */
    @JvmName("kurkwjteomnqthen")
    public suspend fun zones(`value`: Output<String>) {
        this.zones = value
    }

    /**
     * @param value Gets or sets the frontend IP configuration name.
     */
    @JvmName("luydxnoltddhonqd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets or sets the IP address of the Load Balancer.This is only specified if a specific
     * private IP address shall be allocated from the subnet specified in subnetRef.
     */
    @JvmName("ajsgcbfxwaqmhfec")
    public suspend fun privateIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAddress = mapped
    }

    /**
     * @param value Gets or sets PrivateIP allocation method (Static/Dynamic).
     */
    @JvmName("digimbbajmgyuseh")
    public suspend fun privateIpAllocationMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateIpAllocationMethod = mapped
    }

    /**
     * @param value Defines reference to subnet.
     */
    @JvmName("ranvovkwfkqnftcx")
    public suspend fun subnet(`value`: SubnetReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Defines reference to subnet.
     */
    @JvmName("nbsvksyypdeqjtya")
    public suspend fun subnet(argument: suspend SubnetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = SubnetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    /**
     * @param value Gets or sets the csv list of zones.
     */
    @JvmName("tcxlmlasgitiywro")
    public suspend fun zones(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): LBFrontendIPConfigurationResourceSettingsArgs =
        LBFrontendIPConfigurationResourceSettingsArgs(
            name = name,
            privateIpAddress = privateIpAddress,
            privateIpAllocationMethod = privateIpAllocationMethod,
            subnet = subnet,
            zones = zones,
        )
}
