@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LoadBalancerNatRuleReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines reference to load balancer NAT rules.
 * @property name Gets the name of the proxy resource on the target side.
 * @property sourceArmResourceId Gets the ARM resource ID of the tracked resource being referenced.
 */
public data class LoadBalancerNatRuleReferenceArgs(
    public val name: Output<String>? = null,
    public val sourceArmResourceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LoadBalancerNatRuleReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.LoadBalancerNatRuleReferenceArgs =
        com.pulumi.azurenative.migrate.inputs.LoadBalancerNatRuleReferenceArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sourceArmResourceId(sourceArmResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerNatRuleReferenceArgs].
 */
@PulumiTagMarker
public class LoadBalancerNatRuleReferenceArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceArmResourceId: Output<String>? = null

    /**
     * @param value Gets the name of the proxy resource on the target side.
     */
    @JvmName("yhikluonistpsuaf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("forckyolhusiyjkt")
    public suspend fun sourceArmResourceId(`value`: Output<String>) {
        this.sourceArmResourceId = value
    }

    /**
     * @param value Gets the name of the proxy resource on the target side.
     */
    @JvmName("cjmjxjleadkuqprn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Gets the ARM resource ID of the tracked resource being referenced.
     */
    @JvmName("ijahrfbapbksiwes")
    public suspend fun sourceArmResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceArmResourceId = mapped
    }

    internal fun build(): LoadBalancerNatRuleReferenceArgs = LoadBalancerNatRuleReferenceArgs(
        name = name,
        sourceArmResourceId = sourceArmResourceId ?: throw PulumiNullFieldException("sourceArmResourceId"),
    )
}
