@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.LoadBalancerResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the load balancer resource settings.
 * @property backendAddressPools Gets or sets the backend address pools of the load balancer.
 * @property frontendIPConfigurations Gets or sets the frontend IP configurations of the load balancer.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/loadBalancers'.
 * @property sku Gets or sets load balancer sku (Basic/Standard).
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 * @property zones Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
 *  precedence only if frontend IP configurations settings are not present.
 */
public data class LoadBalancerResourceSettingsArgs(
    public val backendAddressPools: Output<List<LBBackendAddressPoolResourceSettingsArgs>>? = null,
    public val frontendIPConfigurations: Output<List<LBFrontendIPConfigurationResourceSettingsArgs>>? =
        null,
    public val resourceType: Output<String>,
    public val sku: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
    public val zones: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.LoadBalancerResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.LoadBalancerResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.LoadBalancerResourceSettingsArgs.builder()
            .backendAddressPools(
                backendAddressPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frontendIPConfigurations(
                frontendIPConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LoadBalancerResourceSettingsArgs].
 */
@PulumiTagMarker
public class LoadBalancerResourceSettingsArgsBuilder internal constructor() {
    private var backendAddressPools: Output<List<LBBackendAddressPoolResourceSettingsArgs>>? = null

    private var frontendIPConfigurations: Output<List<LBFrontendIPConfigurationResourceSettingsArgs>>? =
        null

    private var resourceType: Output<String>? = null

    private var sku: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    private var zones: Output<String>? = null

    /**
     * @param value Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("hqgtsboofpnfmvhx")
    public suspend
    fun backendAddressPools(`value`: Output<List<LBBackendAddressPoolResourceSettingsArgs>>) {
        this.backendAddressPools = value
    }

    @JvmName("wxhirhgmbekhvmyl")
    public suspend fun backendAddressPools(
        vararg
        values: Output<LBBackendAddressPoolResourceSettingsArgs>,
    ) {
        this.backendAddressPools = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("umjfugvtupwvncbf")
    public suspend
    fun backendAddressPools(values: List<Output<LBBackendAddressPoolResourceSettingsArgs>>) {
        this.backendAddressPools = Output.all(values)
    }

    /**
     * @param value Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("mdtmlnmlqljinymy")
    public suspend
    fun frontendIPConfigurations(`value`: Output<List<LBFrontendIPConfigurationResourceSettingsArgs>>) {
        this.frontendIPConfigurations = value
    }

    @JvmName("tfsaapjmgphjjhyx")
    public suspend fun frontendIPConfigurations(
        vararg
        values: Output<LBFrontendIPConfigurationResourceSettingsArgs>,
    ) {
        this.frontendIPConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("upygbscbsosinrsb")
    public suspend
    fun frontendIPConfigurations(values: List<Output<LBFrontendIPConfigurationResourceSettingsArgs>>) {
        this.frontendIPConfigurations = Output.all(values)
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/loadBalancers'.
     */
    @JvmName("cxfpprjmswwoakbs")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets load balancer sku (Basic/Standard).
     */
    @JvmName("fcwkpvhoqrhsbpkw")
    public suspend fun sku(`value`: Output<String>) {
        this.sku = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("tvpwbojytteysqkb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("qcwpcnrfmdxghwcq")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("dnhvdjkqlqgyldom")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
     *  precedence only if frontend IP configurations settings are not present.
     */
    @JvmName("iexbothttjvjedeh")
    public suspend fun zones(`value`: Output<String>) {
        this.zones = value
    }

    /**
     * @param value Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("blhdfvxqxncloghq")
    public suspend fun backendAddressPools(`value`: List<LBBackendAddressPoolResourceSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("ximmuhuamadixkps")
    public suspend
    fun backendAddressPools(argument: List<suspend LBBackendAddressPoolResourceSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LBBackendAddressPoolResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("ljclvxjsqkaceskh")
    public suspend fun backendAddressPools(
        vararg
        argument: suspend LBBackendAddressPoolResourceSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LBBackendAddressPoolResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param argument Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("cqllblxixdukdpfj")
    public suspend
    fun backendAddressPools(argument: suspend LBBackendAddressPoolResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LBBackendAddressPoolResourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.backendAddressPools = mapped
    }

    /**
     * @param values Gets or sets the backend address pools of the load balancer.
     */
    @JvmName("wdvgigfqgmcaqvqa")
    public suspend fun backendAddressPools(vararg values: LBBackendAddressPoolResourceSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backendAddressPools = mapped
    }

    /**
     * @param value Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("tspbbasgamtwvysv")
    public suspend
    fun frontendIPConfigurations(`value`: List<LBFrontendIPConfigurationResourceSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("dsqlwfxncocjkxtt")
    public suspend
    fun frontendIPConfigurations(argument: List<suspend LBFrontendIPConfigurationResourceSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LBFrontendIPConfigurationResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("rywfmpefarppuada")
    public suspend fun frontendIPConfigurations(
        vararg
        argument: suspend LBFrontendIPConfigurationResourceSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            LBFrontendIPConfigurationResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("ikosvtisditpqwmu")
    public suspend
    fun frontendIPConfigurations(argument: suspend LBFrontendIPConfigurationResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            LBFrontendIPConfigurationResourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param values Gets or sets the frontend IP configurations of the load balancer.
     */
    @JvmName("uvyxxbvtveswyayk")
    public suspend fun frontendIPConfigurations(
        vararg
        values: LBFrontendIPConfigurationResourceSettingsArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendIPConfigurations = mapped
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/loadBalancers'.
     */
    @JvmName("cnjsohtqrbipyeja")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets load balancer sku (Basic/Standard).
     */
    @JvmName("aywgjrggypukdiql")
    public suspend fun sku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("fwylthvdjcgycegt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("nlcwpicgqlunghii")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("naakldkvkacmedwk")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("rtujnhgcgjfuagda")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    /**
     * @param value Gets or sets the csv list of zones common for all frontend IP configurations. Note this is given
     *  precedence only if frontend IP configurations settings are not present.
     */
    @JvmName("dyaijonsfuhhswwu")
    public suspend fun zones(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): LoadBalancerResourceSettingsArgs = LoadBalancerResourceSettingsArgs(
        backendAddressPools = backendAddressPools,
        frontendIPConfigurations = frontendIPConfigurations,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        sku = sku,
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
        zones = zones,
    )
}
