@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MigrateProjectTagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Gets or sets the tags.
 * @property additionalProperties
 */
public data class MigrateProjectTagsArgs(
    public val additionalProperties: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MigrateProjectTagsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MigrateProjectTagsArgs =
        com.pulumi.azurenative.migrate.inputs.MigrateProjectTagsArgs.builder()
            .additionalProperties(additionalProperties?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrateProjectTagsArgs].
 */
@PulumiTagMarker
public class MigrateProjectTagsArgsBuilder internal constructor() {
    private var additionalProperties: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("swfnynncowwyjjwo")
    public suspend fun additionalProperties(`value`: Output<String>) {
        this.additionalProperties = value
    }

    /**
     * @param value
     */
    @JvmName("snqqttrhbonukddv")
    public suspend fun additionalProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalProperties = mapped
    }

    internal fun build(): MigrateProjectTagsArgs = MigrateProjectTagsArgs(
        additionalProperties = additionalProperties,
    )
}
