@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MigrationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MigrationConfiguration properties.
 * @property keyVaultResourceId Gets or sets the key vault resource Id.
 * @property migrationSolutionResourceId Gets or sets the migration solution resource Id.
 * @property storageAccountResourceId Gets or sets the storage account resource Id.
 */
public data class MigrationConfigurationArgs(
    public val keyVaultResourceId: Output<String>? = null,
    public val migrationSolutionResourceId: Output<String>? = null,
    public val storageAccountResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MigrationConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MigrationConfigurationArgs =
        com.pulumi.azurenative.migrate.inputs.MigrationConfigurationArgs.builder()
            .keyVaultResourceId(keyVaultResourceId?.applyValue({ args0 -> args0 }))
            .migrationSolutionResourceId(migrationSolutionResourceId?.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MigrationConfigurationArgs].
 */
@PulumiTagMarker
public class MigrationConfigurationArgsBuilder internal constructor() {
    private var keyVaultResourceId: Output<String>? = null

    private var migrationSolutionResourceId: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    /**
     * @param value Gets or sets the key vault resource Id.
     */
    @JvmName("xrdcjupuclhowsmk")
    public suspend fun keyVaultResourceId(`value`: Output<String>) {
        this.keyVaultResourceId = value
    }

    /**
     * @param value Gets or sets the migration solution resource Id.
     */
    @JvmName("kitayufjnyeccpab")
    public suspend fun migrationSolutionResourceId(`value`: Output<String>) {
        this.migrationSolutionResourceId = value
    }

    /**
     * @param value Gets or sets the storage account resource Id.
     */
    @JvmName("kydeqrjvqqeuldyq")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value Gets or sets the key vault resource Id.
     */
    @JvmName("gamhtqtkmqhuuxvj")
    public suspend fun keyVaultResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultResourceId = mapped
    }

    /**
     * @param value Gets or sets the migration solution resource Id.
     */
    @JvmName("ghtmkjairiciqayk")
    public suspend fun migrationSolutionResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationSolutionResourceId = mapped
    }

    /**
     * @param value Gets or sets the storage account resource Id.
     */
    @JvmName("nwtujhvfwjyiusyc")
    public suspend fun storageAccountResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    internal fun build(): MigrationConfigurationArgs = MigrationConfigurationArgs(
        keyVaultResourceId = keyVaultResourceId,
        migrationSolutionResourceId = migrationSolutionResourceId,
        storageAccountResourceId = storageAccountResourceId,
    )
}
