@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MoveCollectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the move collection properties.
 * @property sourceRegion Gets or sets the source region.
 * @property targetRegion Gets or sets the target region.
 * @property version Gets or sets the version of move collection.
 */
public data class MoveCollectionPropertiesArgs(
    public val sourceRegion: Output<String>,
    public val targetRegion: Output<String>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MoveCollectionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MoveCollectionPropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.MoveCollectionPropertiesArgs.builder()
            .sourceRegion(sourceRegion.applyValue({ args0 -> args0 }))
            .targetRegion(targetRegion.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MoveCollectionPropertiesArgs].
 */
@PulumiTagMarker
public class MoveCollectionPropertiesArgsBuilder internal constructor() {
    private var sourceRegion: Output<String>? = null

    private var targetRegion: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Gets or sets the source region.
     */
    @JvmName("gonuvrdastynyltj")
    public suspend fun sourceRegion(`value`: Output<String>) {
        this.sourceRegion = value
    }

    /**
     * @param value Gets or sets the target region.
     */
    @JvmName("vhrofjnsljcjouce")
    public suspend fun targetRegion(`value`: Output<String>) {
        this.targetRegion = value
    }

    /**
     * @param value Gets or sets the version of move collection.
     */
    @JvmName("vhtjejipkbastpuw")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Gets or sets the source region.
     */
    @JvmName("tlogundgasresvor")
    public suspend fun sourceRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceRegion = mapped
    }

    /**
     * @param value Gets or sets the target region.
     */
    @JvmName("uungyhubheeiiadf")
    public suspend fun targetRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRegion = mapped
    }

    /**
     * @param value Gets or sets the version of move collection.
     */
    @JvmName("hnnnefpjpayxtkmu")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): MoveCollectionPropertiesArgs = MoveCollectionPropertiesArgs(
        sourceRegion = sourceRegion ?: throw PulumiNullFieldException("sourceRegion"),
        targetRegion = targetRegion ?: throw PulumiNullFieldException("targetRegion"),
        version = version,
    )
}
