@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.MoveResourceDependencyOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the dependency override of the move resource.
 * @property id Gets or sets the ARM ID of the dependent resource.
 * @property targetId Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
 * the dependent resource.
 */
public data class MoveResourceDependencyOverrideArgs(
    public val id: Output<String>? = null,
    public val targetId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.MoveResourceDependencyOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.MoveResourceDependencyOverrideArgs =
        com.pulumi.azurenative.migrate.inputs.MoveResourceDependencyOverrideArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .targetId(targetId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MoveResourceDependencyOverrideArgs].
 */
@PulumiTagMarker
public class MoveResourceDependencyOverrideArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var targetId: Output<String>? = null

    /**
     * @param value Gets or sets the ARM ID of the dependent resource.
     */
    @JvmName("gspinrnjjviuqncs")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
     * the dependent resource.
     */
    @JvmName("hatuxyhxdpobaopp")
    public suspend fun targetId(`value`: Output<String>) {
        this.targetId = value
    }

    /**
     * @param value Gets or sets the ARM ID of the dependent resource.
     */
    @JvmName("ogvyajanwrskvdif")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets or sets the resource ARM id of either the MoveResource or the resource ARM ID of
     * the dependent resource.
     */
    @JvmName("csigjahrxkodwini")
    public suspend fun targetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetId = mapped
    }

    internal fun build(): MoveResourceDependencyOverrideArgs = MoveResourceDependencyOverrideArgs(
        id = id,
        targetId = targetId,
    )
}
