@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.NetworkInterfaceResourceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the network interface resource settings.
 * @property enableAcceleratedNetworking Gets or sets a value indicating whether accelerated networking is enabled.
 * @property ipConfigurations Gets or sets the IP configurations of the NIC.
 * @property resourceType The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
 * Expected value is 'Microsoft.Network/networkInterfaces'.
 * @property tags Gets or sets the Resource tags.
 * @property targetResourceGroupName Gets or sets the target resource group name.
 * @property targetResourceName Gets or sets the target Resource name.
 */
public data class NetworkInterfaceResourceSettingsArgs(
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val ipConfigurations: Output<List<NicIpConfigurationResourceSettingsArgs>>? = null,
    public val resourceType: Output<String>,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroupName: Output<String>? = null,
    public val targetResourceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.NetworkInterfaceResourceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.NetworkInterfaceResourceSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.NetworkInterfaceResourceSettingsArgs.builder()
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceType(resourceType.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroupName(targetResourceGroupName?.applyValue({ args0 -> args0 }))
            .targetResourceName(targetResourceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkInterfaceResourceSettingsArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceResourceSettingsArgsBuilder internal constructor() {
    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var ipConfigurations: Output<List<NicIpConfigurationResourceSettingsArgs>>? = null

    private var resourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroupName: Output<String>? = null

    private var targetResourceName: Output<String>? = null

    /**
     * @param value Gets or sets a value indicating whether accelerated networking is enabled.
     */
    @JvmName("qjqapgokqqsvinwt")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Gets or sets the IP configurations of the NIC.
     */
    @JvmName("kwmmdrkbfjulbxwh")
    public suspend
    fun ipConfigurations(`value`: Output<List<NicIpConfigurationResourceSettingsArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("giouprfaqputdhhr")
    public suspend fun ipConfigurations(
        vararg
        values: Output<NicIpConfigurationResourceSettingsArgs>,
    ) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the IP configurations of the NIC.
     */
    @JvmName("kvbfawurxlrtlmcr")
    public suspend
    fun ipConfigurations(values: List<Output<NicIpConfigurationResourceSettingsArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/networkInterfaces'.
     */
    @JvmName("fyxshoomfldqojbe")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("nvibtlhfqgclvivi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("vdvsdadpmoipkgcb")
    public suspend fun targetResourceGroupName(`value`: Output<String>) {
        this.targetResourceGroupName = value
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("bmkksngxqcyrbtud")
    public suspend fun targetResourceName(`value`: Output<String>) {
        this.targetResourceName = value
    }

    /**
     * @param value Gets or sets a value indicating whether accelerated networking is enabled.
     */
    @JvmName("qgbbfvdgvhmllcgx")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Gets or sets the IP configurations of the NIC.
     */
    @JvmName("ehdegsvtxbefiqmn")
    public suspend fun ipConfigurations(`value`: List<NicIpConfigurationResourceSettingsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the IP configurations of the NIC.
     */
    @JvmName("sjecysjjimbjevoj")
    public suspend
    fun ipConfigurations(argument: List<suspend NicIpConfigurationResourceSettingsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NicIpConfigurationResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the IP configurations of the NIC.
     */
    @JvmName("byowypvvsjwkhmmn")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend NicIpConfigurationResourceSettingsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NicIpConfigurationResourceSettingsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument Gets or sets the IP configurations of the NIC.
     */
    @JvmName("bepeatfuybqvjgva")
    public suspend
    fun ipConfigurations(argument: suspend NicIpConfigurationResourceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            NicIpConfigurationResourceSettingsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values Gets or sets the IP configurations of the NIC.
     */
    @JvmName("jjwmrumxefpqlkcb")
    public suspend fun ipConfigurations(vararg values: NicIpConfigurationResourceSettingsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The resource type. For example, the value can be Microsoft.Compute/virtualMachines.
     * Expected value is 'Microsoft.Network/networkInterfaces'.
     */
    @JvmName("siswirfkdkaqlhvg")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value Gets or sets the Resource tags.
     */
    @JvmName("vivuiqbxhrgmurap")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Gets or sets the Resource tags.
     */
    @JvmName("dartsxcraohguoui")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Gets or sets the target resource group name.
     */
    @JvmName("hponfrpulqefixyp")
    public suspend fun targetResourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroupName = mapped
    }

    /**
     * @param value Gets or sets the target Resource name.
     */
    @JvmName("dwrwcsdjmuaxjlvb")
    public suspend fun targetResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceName = mapped
    }

    internal fun build(): NetworkInterfaceResourceSettingsArgs = NetworkInterfaceResourceSettingsArgs(
        enableAcceleratedNetworking = enableAcceleratedNetworking,
        ipConfigurations = ipConfigurations,
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
        tags = tags,
        targetResourceGroupName = targetResourceGroupName,
        targetResourceName = targetResourceName ?: throw PulumiNullFieldException("targetResourceName"),
    )
}
