@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.ResourceIdentityArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.ResourceIdentityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property principalId
 * @property tenantId
 * @property type
 * @property userAssignedIdentities
 */
public data class ResourceIdentityArgs(
    public val principalId: Output<String>? = null,
    public val tenantId: Output<String>? = null,
    public val type: Output<Either<String, ResourceIdentityTypes>>? = null,
    public val userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.ResourceIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.ResourceIdentityArgs =
        com.pulumi.azurenative.migrate.inputs.ResourceIdentityArgs.builder()
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceIdentityArgs].
 */
@PulumiTagMarker
public class ResourceIdentityArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var tenantId: Output<String>? = null

    private var type: Output<Either<String, ResourceIdentityTypes>>? = null

    private var userAssignedIdentities: Output<Map<String, UserAssignedIdentityArgs>>? = null

    /**
     * @param value
     */
    @JvmName("qbniorjxhwglscby")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value
     */
    @JvmName("suiefhgijjsijxer")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value
     */
    @JvmName("jwbkirmryrkvbroj")
    public suspend fun type(`value`: Output<Either<String, ResourceIdentityTypes>>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("hkuvvnjqgsprenbp")
    public suspend
    fun userAssignedIdentities(`value`: Output<Map<String, UserAssignedIdentityArgs>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value
     */
    @JvmName("roregwsjmwjrhcak")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value
     */
    @JvmName("emuetyglkciswujb")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    /**
     * @param value
     */
    @JvmName("inwgluknenjbdyhq")
    public suspend fun type(`value`: Either<String, ResourceIdentityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("qmblliyefrknyapf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("ypawsmjcparneyut")
    public fun type(`value`: ResourceIdentityTypes) {
        val toBeMapped = Either.ofRight<String, ResourceIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("racludyysvkdyjcv")
    public suspend fun userAssignedIdentities(`value`: Map<String, UserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param argument
     */
    @JvmName("mpyyicgrioulkkcr")
    public suspend fun userAssignedIdentities(
        vararg
        argument: Pair<String, suspend UserAssignedIdentityArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                UserAssignedIdentityArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values
     */
    @JvmName("formvwblfapbuaki")
    public fun userAssignedIdentities(vararg values: Pair<String, UserAssignedIdentityArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): ResourceIdentityArgs = ResourceIdentityArgs(
        principalId = principalId,
        tenantId = tenantId,
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
