@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SecretStorePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property secretStoreId
 */
public data class SecretStorePropertiesArgs(
    public val secretStoreId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SecretStorePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SecretStorePropertiesArgs =
        com.pulumi.azurenative.migrate.inputs.SecretStorePropertiesArgs.builder()
            .secretStoreId(secretStoreId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretStorePropertiesArgs].
 */
@PulumiTagMarker
public class SecretStorePropertiesArgsBuilder internal constructor() {
    private var secretStoreId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("eobffqbooduiwjad")
    public suspend fun secretStoreId(`value`: Output<String>) {
        this.secretStoreId = value
    }

    /**
     * @param value
     */
    @JvmName("pkacyjgxskxtkbiy")
    public suspend fun secretStoreId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretStoreId = mapped
    }

    internal fun build(): SecretStorePropertiesArgs = SecretStorePropertiesArgs(
        secretStoreId = secretStoreId,
    )
}
