@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Class representing the details of the solution.
 * @property assessmentCount Gets or sets the count of assessments reported by the solution.
 * @property extendedDetails Gets or sets the extended details reported by the solution.
 * @property groupCount Gets or sets the count of groups reported by the solution.
 */
public data class SolutionDetailsArgs(
    public val assessmentCount: Output<Int>? = null,
    public val extendedDetails: Output<Map<String, String>>? = null,
    public val groupCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs =
        com.pulumi.azurenative.migrate.inputs.SolutionDetailsArgs.builder()
            .assessmentCount(assessmentCount?.applyValue({ args0 -> args0 }))
            .extendedDetails(
                extendedDetails?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .groupCount(groupCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionDetailsArgs].
 */
@PulumiTagMarker
public class SolutionDetailsArgsBuilder internal constructor() {
    private var assessmentCount: Output<Int>? = null

    private var extendedDetails: Output<Map<String, String>>? = null

    private var groupCount: Output<Int>? = null

    /**
     * @param value Gets or sets the count of assessments reported by the solution.
     */
    @JvmName("uvwcenrjlabqpovc")
    public suspend fun assessmentCount(`value`: Output<Int>) {
        this.assessmentCount = value
    }

    /**
     * @param value Gets or sets the extended details reported by the solution.
     */
    @JvmName("akrxpktipveivexy")
    public suspend fun extendedDetails(`value`: Output<Map<String, String>>) {
        this.extendedDetails = value
    }

    /**
     * @param value Gets or sets the count of groups reported by the solution.
     */
    @JvmName("fmmeuvyuurwdfmsv")
    public suspend fun groupCount(`value`: Output<Int>) {
        this.groupCount = value
    }

    /**
     * @param value Gets or sets the count of assessments reported by the solution.
     */
    @JvmName("nppsfkdrkwvsoxsq")
    public suspend fun assessmentCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentCount = mapped
    }

    /**
     * @param value Gets or sets the extended details reported by the solution.
     */
    @JvmName("fjahxaydyveqfqcn")
    public suspend fun extendedDetails(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedDetails = mapped
    }

    /**
     * @param values Gets or sets the extended details reported by the solution.
     */
    @JvmName("dlephryhgcfygiog")
    public fun extendedDetails(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedDetails = mapped
    }

    /**
     * @param value Gets or sets the count of groups reported by the solution.
     */
    @JvmName("aambvteyjjyppfki")
    public suspend fun groupCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupCount = mapped
    }

    internal fun build(): SolutionDetailsArgs = SolutionDetailsArgs(
        assessmentCount = assessmentCount,
        extendedDetails = extendedDetails,
        groupCount = groupCount,
    )
}
