@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SqlDbSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSqlDataBaseType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSqlPurchaseModel
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSqlServiceTier
import com.pulumi.azurenative.migrate.kotlin.enums.ComputeTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SQL database assessment settings.
 * @property azureSqlComputeTier Gets or sets the azure SQL compute tier.
 * @property azureSqlDataBaseType Gets or sets the azure PAAS SQL instance type.
 * @property azureSqlPurchaseModel Gets or sets the azure SQL purchase model.
 * @property azureSqlServiceTier Gets or sets the azure SQL service tier.
 */
public data class SqlDbSettingsArgs(
    public val azureSqlComputeTier: Output<Either<String, ComputeTier>>? = null,
    public val azureSqlDataBaseType: Output<Either<String, AzureSqlDataBaseType>>? = null,
    public val azureSqlPurchaseModel: Output<Either<String, AzureSqlPurchaseModel>>? = null,
    public val azureSqlServiceTier: Output<Either<String, AzureSqlServiceTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SqlDbSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SqlDbSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SqlDbSettingsArgs.builder()
            .azureSqlComputeTier(
                azureSqlComputeTier?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureSqlDataBaseType(
                azureSqlDataBaseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureSqlPurchaseModel(
                azureSqlPurchaseModel?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .azureSqlServiceTier(
                azureSqlServiceTier?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SqlDbSettingsArgs].
 */
@PulumiTagMarker
public class SqlDbSettingsArgsBuilder internal constructor() {
    private var azureSqlComputeTier: Output<Either<String, ComputeTier>>? = null

    private var azureSqlDataBaseType: Output<Either<String, AzureSqlDataBaseType>>? = null

    private var azureSqlPurchaseModel: Output<Either<String, AzureSqlPurchaseModel>>? = null

    private var azureSqlServiceTier: Output<Either<String, AzureSqlServiceTier>>? = null

    /**
     * @param value Gets or sets the azure SQL compute tier.
     */
    @JvmName("xcetbswoktancckd")
    public suspend fun azureSqlComputeTier(`value`: Output<Either<String, ComputeTier>>) {
        this.azureSqlComputeTier = value
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("qkoalxhnnkqhocoj")
    public suspend fun azureSqlDataBaseType(`value`: Output<Either<String, AzureSqlDataBaseType>>) {
        this.azureSqlDataBaseType = value
    }

    /**
     * @param value Gets or sets the azure SQL purchase model.
     */
    @JvmName("irgsijyyosusereg")
    public suspend fun azureSqlPurchaseModel(`value`: Output<Either<String, AzureSqlPurchaseModel>>) {
        this.azureSqlPurchaseModel = value
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("wdgexytqxjqbkstw")
    public suspend fun azureSqlServiceTier(`value`: Output<Either<String, AzureSqlServiceTier>>) {
        this.azureSqlServiceTier = value
    }

    /**
     * @param value Gets or sets the azure SQL compute tier.
     */
    @JvmName("arxemupgvovrbevn")
    public suspend fun azureSqlComputeTier(`value`: Either<String, ComputeTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlComputeTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL compute tier.
     */
    @JvmName("lamqhialbwdsmiod")
    public fun azureSqlComputeTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ComputeTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlComputeTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL compute tier.
     */
    @JvmName("yggubdnobbngfoml")
    public fun azureSqlComputeTier(`value`: ComputeTier) {
        val toBeMapped = Either.ofRight<String, ComputeTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlComputeTier = mapped
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("tqncfwtcucsbqsdd")
    public suspend fun azureSqlDataBaseType(`value`: Either<String, AzureSqlDataBaseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlDataBaseType = mapped
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("ashwnbmkrakmscpb")
    public fun azureSqlDataBaseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlDataBaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlDataBaseType = mapped
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("nymmnobwuihskrhb")
    public fun azureSqlDataBaseType(`value`: AzureSqlDataBaseType) {
        val toBeMapped = Either.ofRight<String, AzureSqlDataBaseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlDataBaseType = mapped
    }

    /**
     * @param value Gets or sets the azure SQL purchase model.
     */
    @JvmName("mwffjcolvtvhacua")
    public suspend fun azureSqlPurchaseModel(`value`: Either<String, AzureSqlPurchaseModel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlPurchaseModel = mapped
    }

    /**
     * @param value Gets or sets the azure SQL purchase model.
     */
    @JvmName("skmagxfiswsqlcrd")
    public fun azureSqlPurchaseModel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlPurchaseModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlPurchaseModel = mapped
    }

    /**
     * @param value Gets or sets the azure SQL purchase model.
     */
    @JvmName("cwefldxautqdcmpv")
    public fun azureSqlPurchaseModel(`value`: AzureSqlPurchaseModel) {
        val toBeMapped = Either.ofRight<String, AzureSqlPurchaseModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlPurchaseModel = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("wkhlxqvkkchvstel")
    public suspend fun azureSqlServiceTier(`value`: Either<String, AzureSqlServiceTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("ddgxotlrkttuoaya")
    public fun azureSqlServiceTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlServiceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("ueihjgqantbcrwnv")
    public fun azureSqlServiceTier(`value`: AzureSqlServiceTier) {
        val toBeMapped = Either.ofRight<String, AzureSqlServiceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    internal fun build(): SqlDbSettingsArgs = SqlDbSettingsArgs(
        azureSqlComputeTier = azureSqlComputeTier,
        azureSqlDataBaseType = azureSqlDataBaseType,
        azureSqlPurchaseModel = azureSqlPurchaseModel,
        azureSqlServiceTier = azureSqlServiceTier,
    )
}
