@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SqlMiSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSqlInstanceType
import com.pulumi.azurenative.migrate.kotlin.enums.AzureSqlServiceTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SQL managed instance assessment settings.
 * @property azureSqlInstanceType Gets or sets the azure PAAS SQL instance type.
 * @property azureSqlServiceTier Gets or sets the azure SQL service tier.
 */
public data class SqlMiSettingsArgs(
    public val azureSqlInstanceType: Output<Either<String, AzureSqlInstanceType>>? = null,
    public val azureSqlServiceTier: Output<Either<String, AzureSqlServiceTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SqlMiSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SqlMiSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SqlMiSettingsArgs.builder()
            .azureSqlInstanceType(
                azureSqlInstanceType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .azureSqlServiceTier(
                azureSqlServiceTier?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [SqlMiSettingsArgs].
 */
@PulumiTagMarker
public class SqlMiSettingsArgsBuilder internal constructor() {
    private var azureSqlInstanceType: Output<Either<String, AzureSqlInstanceType>>? = null

    private var azureSqlServiceTier: Output<Either<String, AzureSqlServiceTier>>? = null

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("udkiiympplckfhkw")
    public suspend fun azureSqlInstanceType(`value`: Output<Either<String, AzureSqlInstanceType>>) {
        this.azureSqlInstanceType = value
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("aewysxpfrvvraytc")
    public suspend fun azureSqlServiceTier(`value`: Output<Either<String, AzureSqlServiceTier>>) {
        this.azureSqlServiceTier = value
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("aotvpsjwcsgcrmfg")
    public suspend fun azureSqlInstanceType(`value`: Either<String, AzureSqlInstanceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlInstanceType = mapped
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("akpbljwlkbtowlcb")
    public fun azureSqlInstanceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlInstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlInstanceType = mapped
    }

    /**
     * @param value Gets or sets the azure PAAS SQL instance type.
     */
    @JvmName("niawbkjkmhujxjok")
    public fun azureSqlInstanceType(`value`: AzureSqlInstanceType) {
        val toBeMapped = Either.ofRight<String, AzureSqlInstanceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlInstanceType = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("aqqdnofcbnfgttov")
    public suspend fun azureSqlServiceTier(`value`: Either<String, AzureSqlServiceTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("mpwlcbvdnkjrkxko")
    public fun azureSqlServiceTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AzureSqlServiceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    /**
     * @param value Gets or sets the azure SQL service tier.
     */
    @JvmName("hourbbdrwhrprskp")
    public fun azureSqlServiceTier(`value`: AzureSqlServiceTier) {
        val toBeMapped = Either.ofRight<String, AzureSqlServiceTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.azureSqlServiceTier = mapped
    }

    internal fun build(): SqlMiSettingsArgs = SqlMiSettingsArgs(
        azureSqlInstanceType = azureSqlInstanceType,
        azureSqlServiceTier = azureSqlServiceTier,
    )
}
