@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.SqlVmSettingsArgs.builder
import com.pulumi.azurenative.migrate.kotlin.enums.AzureVmFamily
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SQL VM assessment settings.
 * @property instanceSeries Gets or sets the Azure VM families (calling instance series to keep it
 * consistent with other targets).
 */
public data class SqlVmSettingsArgs(
    public val instanceSeries: Output<List<Either<String, AzureVmFamily>>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.SqlVmSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.SqlVmSettingsArgs =
        com.pulumi.azurenative.migrate.inputs.SqlVmSettingsArgs.builder()
            .instanceSeries(
                instanceSeries?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlVmSettingsArgs].
 */
@PulumiTagMarker
public class SqlVmSettingsArgsBuilder internal constructor() {
    private var instanceSeries: Output<List<Either<String, AzureVmFamily>>>? = null

    /**
     * @param value Gets or sets the Azure VM families (calling instance series to keep it
     * consistent with other targets).
     */
    @JvmName("qhqhstiljkpuohtb")
    public suspend fun instanceSeries(`value`: Output<List<Either<String, AzureVmFamily>>>) {
        this.instanceSeries = value
    }

    @JvmName("hliotjsvmucbxyab")
    public suspend fun instanceSeries(vararg values: Output<Either<String, AzureVmFamily>>) {
        this.instanceSeries = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the Azure VM families (calling instance series to keep it
     * consistent with other targets).
     */
    @JvmName("vbgcnmbjuwnbuafh")
    public suspend fun instanceSeries(values: List<Output<Either<String, AzureVmFamily>>>) {
        this.instanceSeries = Output.all(values)
    }

    /**
     * @param value Gets or sets the Azure VM families (calling instance series to keep it
     * consistent with other targets).
     */
    @JvmName("feirjscmqmwtnqdw")
    public suspend fun instanceSeries(`value`: List<Either<String, AzureVmFamily>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceSeries = mapped
    }

    /**
     * @param values Gets or sets the Azure VM families (calling instance series to keep it
     * consistent with other targets).
     */
    @JvmName("jhhfglbkaqgjahby")
    public suspend fun instanceSeries(vararg values: Either<String, AzureVmFamily>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceSeries = mapped
    }

    internal fun build(): SqlVmSettingsArgs = SqlVmSettingsArgs(
        instanceSeries = instanceSeries,
    )
}
