@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.inputs

import com.pulumi.azurenative.migrate.inputs.UserAssignedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId
 * @property principalId
 */
public data class UserAssignedIdentityArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.migrate.inputs.UserAssignedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.migrate.inputs.UserAssignedIdentityArgs =
        com.pulumi.azurenative.migrate.inputs.UserAssignedIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserAssignedIdentityArgs].
 */
@PulumiTagMarker
public class UserAssignedIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("qubkbjimrhtbiujg")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value
     */
    @JvmName("uvfpenbftrcrsjwi")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value
     */
    @JvmName("nyvovneiakqkemsx")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value
     */
    @JvmName("jrtljdbqkkiucukc")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): UserAssignedIdentityArgs = UserAssignedIdentityArgs(
        clientId = clientId,
        principalId = principalId,
    )
}
