@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for AKSDeployment Properties.
 * @property aksClusterName Gets or sets the AKS cluster name.
 * @property resourceGroup Gets or sets the resource group of the resource.
 * @property subscriptionId Gets or sets the subscription id of the resource.
 * @property tenantId Gets or sets the tenant id.
 */
public data class AKSDeploymentPropertiesResponse(
    public val aksClusterName: String? = null,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.AKSDeploymentPropertiesResponse):
            AKSDeploymentPropertiesResponse = AKSDeploymentPropertiesResponse(
            aksClusterName = javaType.aksClusterName().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
