@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Entity Uptime.
 * @property daysPerMonth Gets the days per month.
 * @property hoursPerDay Gets the hours per day.
 */
public data class EntityUptimeResponse(
    public val daysPerMonth: Int? = null,
    public val hoursPerDay: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.EntityUptimeResponse):
            EntityUptimeResponse = EntityUptimeResponse(
            daysPerMonth = javaType.daysPerMonth().map({ args0 -> args0 }).orElse(null),
            hoursPerDay = javaType.hoursPerDay().map({ args0 -> args0 }).orElse(null),
        )
    }
}
