@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An assessment created for a group in the Migration project.
 * @property eTag For optimistic concurrency control.
 * @property id Path reference to this assessment. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessment/{assessmentName}
 * @property name Unique name of an assessment.
 * @property properties Properties of the assessment.
 * @property type Type of the object = [Microsoft&#46;Migrate/assessmentProjects/groups/assessments].
 */
public data class GetAssessmentResult(
    public val eTag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: AssessmentPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetAssessmentResult):
            GetAssessmentResult = GetAssessmentResult(
            eTag = javaType.eTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.AssessmentPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
