@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Group resource.
 * @property areAssessmentsRunning If the assessments are in running state.
 * @property assessments List of References to Assessments created on this group.
 * @property createdTimestamp Time when this group was created. Date-Time represented in ISO-8601 format.
 * @property groupStatus Whether the group has been created and is valid.
 * @property groupType The type of group.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property machineCount Number of machines part of this group.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property supportedAssessmentTypes List of assessment types supported on this group.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property updatedTimestamp Time when this group was last updated. Date-Time represented in ISO-8601 format.
 */
public data class GetGroupsOperationResult(
    public val areAssessmentsRunning: Boolean,
    public val assessments: List<String>,
    public val createdTimestamp: String,
    public val groupStatus: String,
    public val groupType: String? = null,
    public val id: String,
    public val machineCount: Int,
    public val name: String,
    public val provisioningState: String? = null,
    public val supportedAssessmentTypes: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetGroupsOperationResult):
            GetGroupsOperationResult = GetGroupsOperationResult(
            areAssessmentsRunning = javaType.areAssessmentsRunning(),
            assessments = javaType.assessments().map({ args0 -> args0 }),
            createdTimestamp = javaType.createdTimestamp(),
            groupStatus = javaType.groupStatus(),
            groupType = javaType.groupType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            machineCount = javaType.machineCount(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            supportedAssessmentTypes = javaType.supportedAssessmentTypes().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
