@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Solution REST Resource.
 * @property etag Gets or sets the ETAG for optimistic concurrency control.
 * @property id Gets the relative URL to get to this REST resource.
 * @property name Gets the name of this REST resource.
 * @property properties Gets or sets the properties of the solution.
 * @property type Gets the type of this REST resource.
 */
public data class GetSolutionResult(
    public val etag: String? = null,
    public val id: String,
    public val name: String,
    public val properties: SolutionPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.GetSolutionResult):
            GetSolutionResult = GetSolutionResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.migrate.kotlin.outputs.SolutionPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
