@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IIS workload instance model custom properties.
 * @property containerName Gets or sets the container Id.
 * @property fileshareName Gets or sets the fileshare name.
 * @property iisWebApplication IISWeb application.
 * @property instanceType Gets or sets the instance type.
 * Expected value is 'IISWorkloadInstanceModelCustomProperties'.
 * @property webAppArmId Gets or sets the Web application ARM id.
 * @property webAppSiteName Gets or sets the Web application site name.
 */
public data class IISWorkloadInstanceModelCustomPropertiesResponse(
    public val containerName: String? = null,
    public val fileshareName: String? = null,
    public val iisWebApplication: IISWebApplicationResponse? = null,
    public val instanceType: String,
    public val webAppArmId: String? = null,
    public val webAppSiteName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.IISWorkloadInstanceModelCustomPropertiesResponse):
            IISWorkloadInstanceModelCustomPropertiesResponse =
            IISWorkloadInstanceModelCustomPropertiesResponse(
                containerName = javaType.containerName().map({ args0 -> args0 }).orElse(null),
                fileshareName = javaType.fileshareName().map({ args0 -> args0 }).orElse(null),
                iisWebApplication = javaType.iisWebApplication().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.migrate.kotlin.outputs.IISWebApplicationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                instanceType = javaType.instanceType(),
                webAppArmId = javaType.webAppArmId().map({ args0 -> args0 }).orElse(null),
                webAppSiteName = javaType.webAppSiteName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
