@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createdTimestamp
 * @property discoverySiteId
 * @property updatedTimestamp
 */
public data class ImportCollectorPropertiesResponse(
    public val createdTimestamp: String,
    public val discoverySiteId: String? = null,
    public val updatedTimestamp: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ImportCollectorPropertiesResponse):
            ImportCollectorPropertiesResponse = ImportCollectorPropertiesResponse(
            createdTimestamp = javaType.createdTimestamp(),
            discoverySiteId = javaType.discoverySiteId().map({ args0 -> args0 }).orElse(null),
            updatedTimestamp = javaType.updatedTimestamp(),
        )
    }
}
