@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines load balancer frontend IP configuration properties.
 * @property name Gets or sets the frontend IP configuration name.
 * @property privateIpAddress Gets or sets the IP address of the Load Balancer.This is only specified if a specific
 * private IP address shall be allocated from the subnet specified in subnetRef.
 * @property privateIpAllocationMethod Gets or sets PrivateIP allocation method (Static/Dynamic).
 * @property subnet Defines reference to subnet.
 * @property zones Gets or sets the csv list of zones.
 */
public data class LBFrontendIPConfigurationResourceSettingsResponse(
    public val name: String? = null,
    public val privateIpAddress: String? = null,
    public val privateIpAllocationMethod: String? = null,
    public val subnet: SubnetReferenceResponse? = null,
    public val zones: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.LBFrontendIPConfigurationResourceSettingsResponse):
            LBFrontendIPConfigurationResourceSettingsResponse =
            LBFrontendIPConfigurationResourceSettingsResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
                privateIpAllocationMethod = javaType.privateIpAllocationMethod().map({ args0 ->
                    args0
                }).orElse(null),
                subnet = javaType.subnet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.migrate.kotlin.outputs.SubnetReferenceResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                zones = javaType.zones().map({ args0 -> args0 }).orElse(null),
            )
    }
}
