@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientId
 * @property managedIdentityName
 * @property principalId
 * @property resourceGroup
 * @property subscriptionId
 * @property tenantId
 */
public data class ManagedIdentityPropertiesResponse(
    public val clientId: String? = null,
    public val managedIdentityName: String? = null,
    public val principalId: String? = null,
    public val resourceGroup: String? = null,
    public val subscriptionId: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.ManagedIdentityPropertiesResponse):
            ManagedIdentityPropertiesResponse = ManagedIdentityPropertiesResponse(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            managedIdentityName = javaType.managedIdentityName().map({ args0 -> args0 }).orElse(null),
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
