@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.migrate.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * MigrationConfiguration properties.
 * @property keyVaultResourceId Gets or sets the key vault resource Id.
 * @property migrationSolutionResourceId Gets or sets the migration solution resource Id.
 * @property storageAccountResourceId Gets or sets the storage account resource Id.
 */
public data class MigrationConfigurationResponse(
    public val keyVaultResourceId: String? = null,
    public val migrationSolutionResourceId: String? = null,
    public val storageAccountResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.migrate.outputs.MigrationConfigurationResponse):
            MigrationConfigurationResponse = MigrationConfigurationResponse(
            keyVaultResourceId = javaType.keyVaultResourceId().map({ args0 -> args0 }).orElse(null),
            migrationSolutionResourceId = javaType.migrationSolutionResourceId().map({ args0 ->
                args0
            }).orElse(null),
            storageAccountResourceId = javaType.storageAccountResourceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
